/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import oracle.bpm.lang.Str;
import oracle.bpm.util.TimeZoneItem;

public final class TimeZones {
    private static final Map<Locale, TimeZoneItem[]> sortedTimeZonesItemsCache = new HashMap<Locale, TimeZoneItem[]>();

    private TimeZones() {
    }

    public static String getDefault() {
        return TimeZone.getDefault().getID();
    }

    public static TimeZoneItem getNearestTimeZoneItem(String tzID) {
        return TimeZones.getNearestTimeZoneItem(tzID, Locale.getDefault());
    }

    public static TimeZoneItem getNearestTimeZoneItem(String tzID, Locale locale) {
        TimeZone timeZone = Str.isEmpty(tzID) ? null : TimeZone.getTimeZone(tzID);
        return TimeZones.getNearestTimeZoneItem(timeZone, locale);
    }

    public static TimeZoneItem getNearestTimeZoneItem(TimeZone timeZone) {
        return TimeZones.getNearestTimeZoneItem(timeZone, Locale.getDefault());
    }

    public static TimeZoneItem getNearestTimeZoneItem(TimeZone timeZone, Locale locale) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        TimeZoneItem[] timeZones = TimeZones.getSortedTimeZonesItems(locale);
        String tzID = timeZone.getID();
        for (TimeZoneItem tzi : timeZones) {
            if (!tzID.equals(tzi.getID())) continue;
            return tzi;
        }
        int offset = timeZone.getRawOffset();
        for (TimeZoneItem tzi : timeZones) {
            if (tzi.getRawOffset() != offset) continue;
            return tzi;
        }
        return new TimeZoneItem(timeZone, locale);
    }

    public static TimeZone getNearestTimeZoneFromItems(TimeZone timeZone) {
        return TimeZones.getNearestTimeZoneItem(timeZone).getTimeZone();
    }

    public static TimeZoneItem[] getSortedTimeZonesItems() {
        return TimeZones.getSortedTimeZonesItems(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZoneItem[] getSortedTimeZonesItems(Locale locale) {
        TimeZoneItem[] result;
        Map<Locale, TimeZoneItem[]> cache;
        Map<Locale, TimeZoneItem[]> map = cache = sortedTimeZonesItemsCache;
        synchronized (map) {
            result = cache.get(locale);
            if (result == null) {
                result = TimeZones.createSortedItems(locale);
                cache.put(locale, result);
            }
        }
        return result;
    }

    private static TimeZoneItem[] createSortedItems(Locale locale) {
        final Collator collator = Collator.getInstance(locale);
        TreeSet<TimeZoneItem> sortedSet = new TreeSet<TimeZoneItem>(new Comparator<TimeZoneItem>(){

            @Override
            public int compare(TimeZoneItem o1, TimeZoneItem o2) {
                int offset = o1.getRawOffset() - o2.getRawOffset();
                if (offset != 0) {
                    return offset;
                }
                return collator.compare(o1.toString(), o2.toString());
            }
        });
        for (String id : TimeZone.getAvailableIDs()) {
            sortedSet.add(new TimeZoneItem(TimeZone.getTimeZone(id), locale));
        }
        TimeZoneItem[] result = new TimeZoneItem[sortedSet.size()];
        return sortedSet.toArray(result);
    }
}

