/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class StringTokenizer
implements Enumeration {
    private int currentPosition_d = 0;
    private final String delimiter_d;
    private int maxPosition_d;
    private final String str_d;

    public StringTokenizer(String str_d) {
        this(str_d, ",");
    }

    public StringTokenizer(String str, String delim) {
        this.str_d = str;
        this.delimiter_d = delim;
        this.maxPosition_d = this.str_d.lastIndexOf(this.delimiter_d);
        this.maxPosition_d = this.maxPosition_d == -1 ? 0 : (this.maxPosition_d += this.delimiter_d.length());
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.currentPosition_d != -1;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (this.currentPosition_d == -1) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition_d;
        int end = this.str_d.indexOf(this.delimiter_d, start);
        if (end == -1) {
            this.currentPosition_d = -1;
            return this.str_d.substring(start);
        }
        this.currentPosition_d = end + this.delimiter_d.length();
        return this.str_d.substring(start, end);
    }
}

