/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public final class StackTrace {
    public static String getStackTrace(Throwable t) {
        return StackTrace.getStackTrace(t, 0, Integer.MAX_VALUE);
    }

    public static String getStackTrace() {
        return StackTrace.getStackTrace(new Throwable(), 0, Integer.MAX_VALUE);
    }

    public static String getStackTrace(int numFrames) {
        return StackTrace.getStackTrace(new Throwable(), 0, numFrames);
    }

    public static String getStackTrace(int skipFrames, int numFrames) {
        return StackTrace.getStackTrace(new Throwable(), skipFrames, numFrames);
    }

    public static String getStackTrace(Throwable exc, int skipFrames, int numFrames) {
        String result;
        String string = result = numFrames == 0 ? "empty" : "Trace: empty";
        if (numFrames < 0) {
            return result;
        }
        String s = StackTrace._getStackTrace(exc, 0);
        int pos = 0;
        for (int i = skipFrames + 2; i > 0; --i) {
            int next = s.indexOf(10, pos);
            if (next < 0) {
                return result;
            }
            pos = next + 1;
        }
        if (numFrames == 0) {
            int next = s.indexOf(10, pos);
            if (next < 0 && pos == (next = s.length())) {
                return result;
            }
            result = s.substring(pos, next);
            if (result.startsWith("\tat ")) {
                result = result.substring(4);
            }
            return result;
        }
        StringBuffer b = new StringBuffer();
        for (int i = numFrames; i > 0; --i) {
            int next = s.indexOf(10, pos);
            if (next < 0) {
                if (pos == s.length()) {
                    if (b.length() != 0) break;
                    return result;
                }
                next = s.length();
                i = 0;
            }
            if (b.length() == 0) {
                b.append("Trace:");
            } else {
                b.append("\n    +:");
            }
            b.append(s.substring(pos, next));
            pos = next + 1;
        }
        return b.toString();
    }

    public static String getUserStackTrace(Throwable t) {
        StackTraceElement element;
        String className;
        StackTraceElement[] stack;
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] arr$ = stack = t.getStackTrace();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(className = (element = arr$[i$]).getClassName()).startsWith("fuego."); ++i$) {
            buffer.append("\tat ").append(className).append(".").append(element.getMethodName());
            buffer.append('(');
            int lineNumber = element.getLineNumber();
            buffer.append(element.getFileName()).append(":").append(lineNumber >= 0 ? String.valueOf(lineNumber) : "unknown");
            buffer.append(')');
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private static String _getStackTrace(Throwable exc, int indent) {
        StringWriter out = new StringWriter();
        exc.printStackTrace(new PrintWriter(out));
        String str = out.toString();
        if (indent == 0) {
            return str;
        }
        StringBuffer buff = new StringBuffer(str.length());
        StringTokenizer strtok = new StringTokenizer(str, "\n");
        String indentString = StackTrace.spaces(indent);
        while (strtok.hasMoreTokens()) {
            String line = strtok.nextToken();
            buff.append(indentString).append(line).append('\n');
        }
        return buff.toString();
    }

    private static String spaces(int indent) {
        StringBuffer buff = new StringBuffer(0);
        if (indent > 0) {
            buff = new StringBuffer(indent);
        }
        while (indent-- > 0) {
            buff.append(' ');
        }
        return buff.toString();
    }
}

