/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.lang.Str;

public class Properties
extends java.util.Properties {
    private static final long serialVersionUID = 5315008157482825355L;

    public Properties() {
    }

    public Properties(java.util.Properties prop) {
        super(prop);
    }

    public static void store(Map values, OutputStream out, String[] headers) throws IOException {
        Properties.store(values.keySet().iterator(), values, out, headers);
    }

    public static void store(Iterator keys, Map values, OutputStream out, String[] headers) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (headers != null && headers.length > 0) {
            for (String header : headers) {
                if (header == null) continue;
                Properties.writeln(awriter, "#" + header);
            }
        }
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = (String)values.get(key);
            key = Properties.saveConvert(key, true);
            val = val == null ? "" : Properties.saveConvert(val, false);
            Properties.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        int c = reader.read();
        block20: while (true) {
            switch (c) {
                case -1: {
                    return;
                }
                case 64: {
                    StringBuilder fileName = new StringBuilder();
                    c = reader.read();
                    while (c != -1 && c != 10) {
                        fileName.append((char)c);
                        c = reader.read();
                    }
                    if ("".equals(fileName.toString())) continue block20;
                    try {
                        Properties prop = new Properties();
                        FileInputStream stream = new FileInputStream(fileName.toString());
                        try {
                            prop.load(stream);
                        }
                        finally {
                            stream.close();
                        }
                        Enumeration<?> propertyNames = prop.propertyNames();
                        while (true) {
                            if (!propertyNames.hasMoreElements()) continue block20;
                            String name = (String)propertyNames.nextElement();
                            this.put(name, prop.get(name));
                        }
                    }
                    catch (FileNotFoundException exc) {
                        continue block20;
                    }
                }
                case 33: 
                case 35: {
                    c = reader.read();
                    while (true) {
                        if (c < 0 || c == 10 || c == 13) continue block20;
                        c = reader.read();
                    }
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    c = reader.read();
                    continue block20;
                }
            }
            StringBuilder key = new StringBuilder();
            block24: while (true) {
                key.append((char)c);
                c = reader.read();
                switch (c) {
                    case -1: {
                        return;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 58: 
                    case 61: {
                        break block24;
                    }
                    default: {
                        continue block24;
                    }
                }
                break;
            }
            while (c == 32 || c == 9) {
                c = reader.read();
            }
            if (c == 61 || c == 58) {
                c = reader.read();
            }
            while (c == 32 || c == 9) {
                c = reader.read();
            }
            StringBuilder value = new StringBuilder();
            int junk = 0;
            block27: while (true) {
                switch (c) {
                    case -1: {
                        return;
                    }
                    case 10: 
                    case 13: {
                        break block27;
                    }
                    case 9: 
                    case 32: {
                        ++junk;
                        break;
                    }
                    default: {
                        junk = 0;
                    }
                }
                value.append((char)c);
                c = reader.read();
            }
            if (junk > 0) {
                value.setLength(value.length() - junk);
            }
            this.put(key.toString(), this.loadConvert(value.toString()));
        }
    }

    public String toSeparatedString(String separator) {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            if (ret.length() > 0) {
                ret.append(separator);
            }
            ret.append(entry.getKey());
            ret.append('=');
            ret.append(entry.getValue());
        }
        return ret.toString();
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        return Str.encodeUnicodeChars(theString, escapeSpace);
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private String loadConvert(String theString) {
        return Str.decodeUnicodeChars(theString);
    }
}

