/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import oracle.bpm.util.BinaryPattern;
import org.jetbrains.annotations.NotNull;

public class ObjectStreamReplacer {
    @NotNull
    private final BinaryPattern<Substitution> pattern = new BinaryPattern();

    /*
     * WARNING - void declaration
     */
    public void addSubstitution(@NotNull String className, long oldSerialUID, long l) {
        void newSerialUID;
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/ObjectStreamReplacer.addSubstitution must not be null");
        }
        this.addSubstitution(className, oldSerialUID, className, (long)newSerialUID);
    }

    /*
     * WARNING - void declaration
     */
    public void addSubstitution(@NotNull String oldClassName, long oldSerialUID, @NotNull String newClassName, long l) {
        void newSerialUID;
        if (oldClassName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/ObjectStreamReplacer.addSubstitution must not be null");
        }
        if (newClassName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/util/ObjectStreamReplacer.addSubstitution must not be null");
        }
        Substitution substitution = new Substitution(this.makePattern(oldClassName, oldSerialUID), this.makePattern(newClassName, (long)newSerialUID));
        this.pattern.add(substitution.oldPattern, substitution);
    }

    public void build() {
        this.pattern.build();
    }

    public byte[] replace(byte[] src) {
        BinaryPattern.Matcher<Substitution> matcher = this.pattern.createMatcher();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int start = 0;
        for (int i = 0; i < src.length; ++i) {
            List<Substitution> matches = matcher.match(src[i]);
            if (matches.isEmpty()) continue;
            assert (matches.size() == 1) : "Unexpected number of matches";
            Substitution subst = matches.get(0);
            baos.write(src, start, i - start - subst.oldPattern.length + 1);
            baos.write(subst.newPattern, 0, subst.newPattern.length);
            start = i + 1;
        }
        baos.write(src, start, src.length - start);
        return baos.toByteArray();
    }

    private byte[] makePattern(String className, long serialUID) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        try {
            daos.writeByte(114);
            daos.writeUTF(className);
            daos.writeLong(serialUID);
            daos.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return baos.toByteArray();
    }

    private static class Substitution {
        final byte[] newPattern;
        final byte[] oldPattern;

        private Substitution(byte[] oldPattern, byte[] newPattern) {
            this.oldPattern = oldPattern;
            this.newPattern = newPattern;
        }
    }
}

