/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.bpm.util.DecimalFormat;
import oracle.bpm.util.DecimalFormatSymbols;
import org.jetbrains.annotations.NonNls;

public abstract class NumberFormat
extends Format {
    private Currency currency;
    private boolean groupingUsed = true;
    private byte maxFractionDigits = (byte)3;
    private int maximumFractionDigits = 3;
    private int maximumIntegerDigits = 40;
    private byte maxIntegerDigits = (byte)40;
    private byte minFractionDigits = 0;
    private int minimumFractionDigits = 0;
    private int minimumIntegerDigits = 1;
    private byte minIntegerDigits = 1;
    private boolean parseIntegerOnly = false;
    private int serialVersionOnStream = 1;
    private static final Method formatDataMethod;
    private static final int ONE = 1;
    @NonNls
    private static final String SCIENTIFIC_PATTERN = "#E0";
    @NonNls
    private static final String ICU_TEXT_NUMBER_FORMAT_SERVICE_SHIM = "com.ibm.icu.text.NumberFormatServiceShim";
    @NonNls
    private static final String NUMBER_PATTERNS = "NumberPatterns";
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static NumberFormatShim shim;
    static final int currentSerialVersion = 1;
    static final long serialVersionUID = -2308460125733713944L;
    static final long serialCheck = -1926003172778210995L;
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private static final int INTEGERSTYLE = 4;

    protected NumberFormat() {
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(BigInteger var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(BigDecimal var1, StringBuffer var2, FieldPosition var3);

    public abstract Number parse(String var1, ParsePosition var2);

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 1);
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 0);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return Locale.getAvailableLocales();
        }
        return NumberFormat.getShim().getAvailableLocales();
    }

    public static NumberFormat getInstance(Locale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 4);
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 0);
    }

    public static NumberFormat getCurrencyInstance(Locale inLocale) {
        return NumberFormat.getInstance(inLocale, 1);
    }

    public static NumberFormat getIntegerInstance(Locale inLocale) {
        return NumberFormat.getInstance(inLocale, 4);
    }

    public static NumberFormat getNumberInstance(Locale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 2);
    }

    public static NumberFormat getPercentInstance(Locale inLocale) {
        return NumberFormat.getInstance(inLocale, 2);
    }

    public static final NumberFormat getScientificInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 3);
    }

    public static NumberFormat getScientificInstance(Locale inLocale) {
        return NumberFormat.getInstance(inLocale, 3);
    }

    public static Object registerFactory(NumberFormatFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        return NumberFormat.getShim().registerFactory(factory);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        return shim != null && shim.unregister(registryKey);
    }

    public static String canonicalLocaleString(String id) {
        if (id != null) {
            int x = id.indexOf("_");
            if (x == -1) {
                id = id.toLowerCase(Locale.ENGLISH);
            } else {
                int len;
                StringBuffer buf = new StringBuffer();
                buf.append(id.substring(0, x).toLowerCase(Locale.ENGLISH));
                buf.append(id.substring(x).toUpperCase(Locale.ENGLISH));
                int n = len = buf.length();
                while (--n >= 0 && buf.charAt(n) == '_') {
                }
                if (++n != len) {
                    buf.delete(n, len);
                }
                id = buf.toString();
            }
        }
        return id;
    }

    public static void main(String[] args) {
        System.out.println(NumberFormat.createInstance(Locale.getDefault(), 0));
    }

    @Override
    public final StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number instanceof Long) {
            return this.format((Long)number, toAppendTo, pos);
        }
        if (number instanceof BigInteger) {
            return this.format((BigInteger)number, toAppendTo, pos);
        }
        if (number instanceof BigDecimal) {
            return this.format((BigDecimal)number, toAppendTo, pos);
        }
        if (number instanceof Number) {
            return this.format(((Number)number).doubleValue(), toAppendTo, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public final String format(double number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(long number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(BigInteger number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(BigDecimal number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    @Override
    public final Object parseObject(String source, ParsePosition parsePosition) {
        return this.parse(source, parsePosition);
    }

    public void setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public Number parse(String text) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = this.parse(text, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable number: \"" + text + "\"", 0);
        }
        return result;
    }

    public void setCurrency(Currency theCurrency) {
        this.currency = theCurrency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setGroupingUsed(boolean newValue) {
        this.groupingUsed = newValue;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setMaximumFractionDigits(int newValue) {
        this.maximumFractionDigits = Math.max(0, newValue);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.maximumIntegerDigits = Math.max(0, newValue);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public void setMinimumFractionDigits(int newValue) {
        this.minimumFractionDigits = Math.max(0, newValue);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.minimumIntegerDigits = Math.max(0, newValue);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    @Override
    public NumberFormat clone() {
        return (NumberFormat)super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberFormat other = (NumberFormat)obj;
        return this.maximumIntegerDigits == other.maximumIntegerDigits && this.minimumIntegerDigits == other.minimumIntegerDigits && this.maximumFractionDigits == other.maximumFractionDigits && this.minimumFractionDigits == other.minimumFractionDigits && this.groupingUsed == other.groupingUsed && this.parseIntegerOnly == other.parseIntegerOnly;
    }

    public int hashCode() {
        return this.maximumIntegerDigits * 37 + this.maxFractionDigits;
    }

    protected static String getPattern(Locale forLocale, int choice) {
        if (choice == 3) {
            return SCIENTIFIC_PATTERN;
        }
        ResourceBundle rb = NumberFormat.getNumberFormatData(forLocale);
        String[] numberPatterns = rb.getStringArray(NUMBER_PATTERNS);
        int entry = choice == 4 ? 0 : choice;
        return numberPatterns[entry];
    }

    static NumberFormat createInstance(Locale desiredLocale, int choice) {
        String pattern = NumberFormat.getPattern(desiredLocale, choice);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(desiredLocale);
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        if (choice == 4) {
            format.setMaximumFractionDigits(0);
            format.setDecimalSeparatorAlwaysShown(false);
            format.setParseIntegerOnly(true);
        }
        return format;
    }

    static ResourceBundle getNumberFormatData(Locale forLocale) {
        ResourceBundle rb;
        try {
            rb = (ResourceBundle)formatDataMethod.invoke(null, forLocale);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new Error(target);
        }
        return rb;
    }

    private static NumberFormat getInstance(Locale desiredLocale, int choice) {
        if (shim == null) {
            return NumberFormat.createInstance(desiredLocale, choice);
        }
        return NumberFormat.getShim().createInstance(desiredLocale, choice);
    }

    private static NumberFormatShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName(ICU_TEXT_NUMBER_FORMAT_SERVICE_SHIM);
                shim = (NumberFormatShim)cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumFractionDigits = this.minFractionDigits;
            this.maximumFractionDigits = this.maxFractionDigits;
        }
        this.checkRange();
        this.serialVersionOnStream = 1;
    }

    private void checkRange() throws InvalidObjectException {
        if (this.minimumIntegerDigits > this.maximumIntegerDigits || this.minimumFractionDigits > this.maximumFractionDigits || this.minimumIntegerDigits < 0 || this.minimumFractionDigits < 0) {
            throw new InvalidObjectException("count range invalid");
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.maxIntegerDigits = this.maximumIntegerDigits > 127 ? (byte)127 : (byte)this.maximumIntegerDigits;
        this.minIntegerDigits = this.minimumIntegerDigits > 127 ? (byte)127 : (byte)this.minimumIntegerDigits;
        this.maxFractionDigits = this.maximumFractionDigits > 127 ? (byte)127 : (byte)this.maximumFractionDigits;
        this.minFractionDigits = this.minimumFractionDigits > 127 ? (byte)127 : (byte)this.minimumFractionDigits;
        stream.defaultWriteObject();
    }

    static {
        Method method = null;
        try {
            try {
                Class<?> localeDataClass = Class.forName("sun.util.resources.LocaleData");
                method = localeDataClass.getMethod("getNumberFormatData", Locale.class);
            }
            catch (ClassNotFoundException e) {
                try {
                    Class<?> localeDataClass = Class.forName("sun.text.resources.LocaleData");
                    method = localeDataClass.getMethod("getLocaleElements", Locale.class);
                }
                catch (ClassNotFoundException e1) {
                    throw new Error(e1);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        assert (method != null) : "unable to find number format data";
        formatDataMethod = method;
    }

    static abstract class NumberFormatShim {
        NumberFormatShim() {
        }

        abstract Locale[] getAvailableLocales();

        abstract NumberFormat createInstance(Locale var1, int var2);

        abstract Object registerFactory(NumberFormatFactory var1);

        abstract boolean unregister(Object var1);
    }

    public static abstract class SimpleNumberFormatFactory
    extends NumberFormatFactory {
        final Set localeNames;
        final boolean visible;

        public SimpleNumberFormatFactory(Locale locale) {
            this(locale, true);
        }

        public SimpleNumberFormatFactory(Locale locale, boolean visible) {
            this.localeNames = Collections.singleton(NumberFormat.canonicalLocaleString(locale.toString()));
            this.visible = visible;
        }

        @Override
        public final Set getSupportedLocaleNames() {
            return this.localeNames;
        }

        @Override
        public final boolean visible() {
            return this.visible;
        }
    }

    public static abstract class NumberFormatFactory {
        public static final int FORMAT_NUMBER = 0;
        public static final int FORMAT_CURRENCY = 1;
        public static final int FORMAT_PERCENT = 2;
        public static final int FORMAT_SCIENTIFIC = 3;
        public static final int FORMAT_INTEGER = 4;

        protected NumberFormatFactory() {
        }

        public abstract Set getSupportedLocaleNames();

        public abstract NumberFormat createFormat(Locale var1, int var2);

        public boolean visible() {
            return true;
        }
    }
}

