/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import oracle.bpm.util.AbstractLazyHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LazyHolder<T>
extends AbstractLazyHolder<T> {
    @Nullable
    private volatile T value;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final T get() {
        T v = this.value;
        T t = v == null ? this.initValue() : v;
        if (t == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/LazyHolder.get must not return null");
        }
        return t;
    }

    @Nullable
    public final T getIfSet() {
        return this.value;
    }

    @Override
    public final void set(@Nullable T value) {
        this.value = value;
    }

    @Override
    public final boolean isSet() {
        return this.value != null;
    }

    @Override
    public final void reset() {
        this.set(null);
    }

    @Override
    @NotNull
    protected abstract T init();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private synchronized T initValue() {
        T t;
        T v = this.value;
        if (v != null) {
            t = v;
            if (t == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/util/LazyHolder.initValue must not return null");
            return t;
        }
        v = this.init();
        assert (v != null);
        t = this.value = v;
        if (this.value != null) return t;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/util/LazyHolder.initValue must not return null");
    }
}

