/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import org.jetbrains.annotations.NonNls;

public class InitialContextProvider {
    @NonNls
    private static final String FUEGO_J2EE_INITIALCTX = "fuego.j2ee.initialctx";
    @NonNls
    private static final String FUEGO_J2EE_FEDERATION = "fuego.j2ee.federation";
    @NonNls
    private static final String FILE = ".file";
    @NonNls
    private static final String RESOURCE = ".resource";
    @NonNls
    private static final String URL = ".url";
    @NonNls
    private static final String JNDI = "jndi.";
    @NonNls
    private static final String LOOKUP_PREFIX = "lookupPrefix.";
    @NonNls
    static final String LOG_DEBUG_PREFIX = "InitialContextProvider-> ";
    @NonNls
    public static final String ORACLEAS_INITIAL_CONTEXT_FACTORY = "com.evermind.server.rmi.RMIInitialContextFactory";

    public static InitialContext create(Properties ctxProperties) throws NamingException {
        return new InitialContext(ctxProperties);
    }

    public static InitialContext create(String engineId) throws IOException, NamingException {
        return new InitialContext(InitialContextProvider.getJndiProperties(engineId));
    }

    public static Properties createJndiProperties(String engineId) throws IOException, NamingException {
        return InitialContextProvider.getJndiProperties(engineId);
    }

    public static Properties createLookupPrefixProperties(String engineId) throws IOException {
        return InitialContextProvider.getLookupPrefixProperties(engineId);
    }

    public static void main(String[] args) throws NamingException, IOException {
        System.setProperty("fuego.j2ee.federation.file", "/tmp/test.properties");
        Properties p = InitialContextProvider.createJndiProperties("engine1");
        System.out.println("jndi = " + p);
        p = InitialContextProvider.createLookupPrefixProperties("engine1");
        System.out.println("lookupPrefix = " + p);
        System.out.println("----------------------------------------------------");
        p = InitialContextProvider.createJndiProperties("engine2");
        System.out.println("jndi = " + p);
        p = InitialContextProvider.createLookupPrefixProperties("engine2");
        System.out.println("lookupPrefix = " + p);
    }

    private static Properties getJndiProperties(String engineId) throws IOException {
        JndiPropertiesInfo propertiesInfo = InitialContextProvider.getProperties(engineId);
        return InitialContextProvider.filterJndiPropertiesForEngine(engineId, propertiesInfo);
    }

    private static Properties getLookupPrefixProperties(String engineId) throws IOException {
        JndiPropertiesInfo propertiesInfo = InitialContextProvider.getProperties(engineId);
        return InitialContextProvider.filterLookupPrefixPropertiesForEngine(engineId, propertiesInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JndiPropertiesInfo getProperties(String engineId) throws IOException {
        Properties contextProperties = new Properties();
        InputStream is = null;
        String federationPropertiesFileName = InitialContextProvider.getSystemProperty("fuego.j2ee.federation.file");
        String federationPropertiesResource = InitialContextProvider.getSystemProperty("fuego.j2ee.federation.resource");
        String federationPropertiesFileUrl = InitialContextProvider.getSystemProperty("fuego.j2ee.federation.url");
        String initialCtxFileName = InitialContextProvider.getSystemProperty("fuego.j2ee.initialctx." + engineId + FILE);
        String initialCtxResourceName = InitialContextProvider.getSystemProperty("fuego.j2ee.initialctx." + engineId + RESOURCE);
        String initialCtxUrl = InitialContextProvider.getSystemProperty("fuego.j2ee.initialctx." + engineId + URL);
        String generalInitialCtxFileName = InitialContextProvider.getSystemProperty("fuego.j2ee.initialctx.file");
        String generalInitialCtxResourceName = InitialContextProvider.getSystemProperty("fuego.j2ee.initialctx.resource");
        String generalInitialCtxUrl = InitialContextProvider.getSystemProperty("fuego.j2ee.initialctx.url");
        boolean federatedProperties = false;
        if (federationPropertiesFileName != null) {
            is = InitialContextProvider.getInputStreamFromFile(federationPropertiesFileName);
            federatedProperties = true;
        } else if (federationPropertiesResource != null) {
            is = InitialContextProvider.getInputStreamFromResource(federationPropertiesResource);
            federatedProperties = true;
        } else if (federationPropertiesFileUrl != null) {
            is = new URL(federationPropertiesFileUrl).openStream();
            federatedProperties = true;
        } else if (initialCtxFileName != null) {
            is = InitialContextProvider.getInputStreamFromFile(initialCtxFileName);
        } else if (initialCtxResourceName != null) {
            is = InitialContextProvider.getInputStreamFromResource(initialCtxResourceName);
        } else if (initialCtxUrl != null) {
            is = new URL(initialCtxUrl).openStream();
        } else if (generalInitialCtxFileName != null) {
            is = InitialContextProvider.getInputStreamFromFile(generalInitialCtxFileName);
        } else if (generalInitialCtxResourceName != null) {
            is = InitialContextProvider.getInputStreamFromResource(generalInitialCtxResourceName);
        } else if (generalInitialCtxUrl != null) {
            is = new URL(generalInitialCtxUrl).openStream();
        }
        if (is != null) {
            try {
                contextProperties.load(is);
            }
            finally {
                is.close();
            }
        }
        if (!contextProperties.isEmpty() && Log.isDebugging()) {
            Log.logDebug("Context Properties found for engine [" + engineId + "]. Properties: " + contextProperties);
        }
        return new JndiPropertiesInfo(contextProperties, federatedProperties);
    }

    private static Properties filterJndiPropertiesForEngine(String engineId, JndiPropertiesInfo propertiesInfo) {
        Properties result = propertiesInfo.isFederated() ? InitialContextProvider.filterProperties(propertiesInfo.getProperties(), engineId, JNDI) : propertiesInfo.getProperties();
        return result;
    }

    private static Properties filterLookupPrefixPropertiesForEngine(String engineId, JndiPropertiesInfo propertiesInfo) {
        if (propertiesInfo.isFederated()) {
            return InitialContextProvider.filterProperties(propertiesInfo.getProperties(), engineId, LOOKUP_PREFIX);
        }
        Properties result = propertiesInfo.getProperties();
        return result;
    }

    private static Properties filterProperties(Properties contextProperties, String engineId, String prefix) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : contextProperties.entrySet()) {
            String enginePrefix;
            String key = (String)entry.getKey();
            if (key.startsWith(enginePrefix = engineId + "." + prefix)) {
                result.put(key.substring(enginePrefix.length()), entry.getValue());
                continue;
            }
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), entry.getValue());
        }
        return result;
    }

    private static String getSystemProperty(String sysPropKey) {
        String result = System.getProperty(sysPropKey);
        if (result != null && Log.isDebugging()) {
            Log.logDebug("InitialContextProvider-> System property [" + sysPropKey + "] is defined. Value: [" + result + "]");
        }
        return result;
    }

    private static InputStream getInputStreamFromResource(String initialCtxResourceName) throws IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(initialCtxResourceName);
        if (resource == null) {
            CoreMsg.IO_ERROR_READING(initialCtxResourceName).logWarning();
            return null;
        }
        return resource.openStream();
    }

    private static InputStream getInputStreamFromFile(String initialCtxFileName) throws FileNotFoundException {
        File initialCtxFile = new File(initialCtxFileName);
        if (!initialCtxFile.exists() || !initialCtxFile.isFile()) {
            CoreMsg.IO_ERROR_READING(initialCtxFileName).logWarning();
            return null;
        }
        return new FileInputStream(initialCtxFile);
    }

    private static class JndiPropertiesInfo {
        private boolean federated;
        private Properties properties;

        private JndiPropertiesInfo(Properties properties, boolean federated) {
            this.properties = properties;
            this.federated = federated;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public boolean isFederated() {
            return this.federated;
        }
    }
}

