/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.DateFormatUtils;

public class FriendlyDateFormat
implements Serializable {
    private int formatStyle;
    private Locale locale;
    public static final int LEAST_FRIENDLY = 0;
    public static final int FRIENDLY = 1;
    public static final int FRIENDLY_FRIENDLIEST = 2;
    public static final int FRIENDLIEST = 3;
    public static final int FRIENDLIEST2 = 4;
    public static final int DATE_TIME_ALWAYS = 5;
    public static final int DEFAULT = 1;
    static final long serialVersionUID = 3599924239980804161L;

    private FriendlyDateFormat(int formatStyle, Locale locale) {
        this.formatStyle = formatStyle;
        this.locale = locale;
    }

    public static FriendlyDateFormat getInstance() {
        return FriendlyDateFormat.getInstance(1);
    }

    public static FriendlyDateFormat getInstance(int formatStyle) {
        return FriendlyDateFormat.getInstance(formatStyle, Locale.getDefault());
    }

    public static FriendlyDateFormat getInstance(int formatStyle, Locale locale) {
        return new FriendlyDateFormat(formatStyle, locale);
    }

    public static String format(Time time, int formatStyle, Locale locale) {
        FriendlyDateFormat friendlyDateFormat = FriendlyDateFormat.getInstance(formatStyle, locale);
        return friendlyDateFormat.format(time);
    }

    public static void main(String[] args) {
        Time theTime = Time.valueOf(2004, 11, 25, 13, 43, 0);
        FriendlyDateFormat friendliestDateFormat = FriendlyDateFormat.getInstance(3, new Locale("en"));
        FriendlyDateFormat friendliest2DateFormat = FriendlyDateFormat.getInstance(4, new Locale("en"));
        FriendlyDateFormat friendlyDateFormat = FriendlyDateFormat.getInstance(1, new Locale("en"));
        FriendlyDateFormat friendlyFriendliestDateFormat = FriendlyDateFormat.getInstance(2, new Locale("en"));
        System.out.println("FriendlyDateFormat =================================");
        System.out.println("now         => " + Time.now());
        System.out.println("theTime     => " + theTime);
        System.out.println("");
        System.out.println("FRIENDLIEST => " + friendliestDateFormat.format(theTime));
        System.out.println("FRIENDLIEST2 => " + friendliest2DateFormat.format(theTime));
        System.out.println("FRIENDLY    => " + friendlyDateFormat.format(theTime));
        System.out.println("FRIENDLY_FRINDLIEST    => " + friendlyFriendliestDateFormat.format(theTime));
    }

    public final String format(Time time) {
        switch (this.formatStyle) {
            case 5: {
                DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2, this.locale);
                return time.format(dateTimeFormatter);
            }
            case 0: {
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, this.locale);
                if (time.getDate().equals(Time.now().getDate())) {
                    formatter = DateFormat.getTimeInstance(2, this.locale);
                    return time.format(formatter);
                }
                if (time.getYear() == Time.now().getYear()) {
                    SimpleDateFormat monthDateFormat = DateFormatUtils.getDateInstance(21, this.locale);
                    DateFormat timeDateFormat = DateFormat.getTimeInstance(3);
                    return time.format(monthDateFormat) + " " + time.format(timeDateFormat);
                }
                return time.format(formatter);
            }
            default: {
                FriendlyDateFormatStyle friendlyDateFormatStyle = new FriendlyDateFormatStyle(time, this.locale);
                return friendlyDateFormatStyle.toString();
            }
            case 2: {
                FriendlyDateFormatStyle friendlyDateFormatStyle1 = new FriendlyDateFormatStyle(time, this.locale);
                FriendliestDateFormatStyle friendliestDateFormatStyle1 = new FriendliestDateFormatStyle(time, this.locale);
                StringBuffer friendlyFriendliestFormat = new StringBuffer();
                friendlyFriendliestFormat.append(friendlyDateFormatStyle1.toString());
                friendlyFriendliestFormat.append(" (");
                friendlyFriendliestFormat.append(friendliestDateFormatStyle1.toString());
                friendlyFriendliestFormat.append(")");
                return friendlyFriendliestFormat.toString();
            }
            case 3: {
                FriendliestDateFormatStyle friendliestDateFormatStyle = new FriendliestDateFormatStyle(time, this.locale);
                return friendliestDateFormatStyle.toString();
            }
            case 4: 
        }
        Friendliest2DateFormatStyle friendliest2DateFormatStyle = new Friendliest2DateFormatStyle(time, this.locale);
        return friendliest2DateFormatStyle.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FriendlyDateFormat that = (FriendlyDateFormat)o;
        if (this.formatStyle != that.formatStyle) {
            return false;
        }
        return !(this.locale != null ? !this.locale.equals(that.locale) : that.locale != null);
    }

    public int hashCode() {
        int result = this.formatStyle;
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        return result;
    }

    private static final class FriendlyDateFormatStyle {
        String formatTime;

        public FriendlyDateFormatStyle(Time time) {
            this(time, Locale.getDefault());
        }

        public FriendlyDateFormatStyle(Time time, Locale locale) {
            this.init(time, locale);
        }

        public String toString() {
            return this.formatTime;
        }

        private void init(Time time, Locale locale) {
            Time endToday;
            Time nowTime = Time.now();
            Time beginToday = Time.valueOf(nowTime.getYear(), nowTime.getMonth(), nowTime.getDay(), 0, 0, 1);
            if (time.between(beginToday, endToday = Time.valueOf(nowTime.getYear(), nowTime.getMonth(), nowTime.getDay(), 23, 59, 59))) {
                DateFormat dateFormat = DateFormat.getTimeInstance(3, locale);
                this.formatTime = time.format(dateFormat);
            } else if (time.getYear() == nowTime.getYear()) {
                SimpleDateFormat monthDateFormat = DateFormatUtils.getDateInstance(21, locale);
                this.formatTime = time.format(monthDateFormat);
            } else {
                DateFormat formatter = DateFormat.getDateInstance(2, locale);
                this.formatTime = time.format(formatter);
            }
        }
    }

    private static final class FriendliestDateFormatStyle {
        private String formatTime;
        private boolean isPast = true;

        public FriendliestDateFormatStyle(Time time) {
            this(time, Locale.getDefault());
        }

        public FriendliestDateFormatStyle(Time time, Locale locale) {
            Time nowTime = Time.now();
            if (time.compareTo(nowTime) < 1) {
                this.setPast(true);
                this.init(time, nowTime, locale);
            } else {
                this.setPast(false);
                this.init(nowTime, time, locale);
            }
        }

        public String toString() {
            return this.formatTime;
        }

        private void setPast(boolean isPast) {
            this.isPast = isPast;
        }

        private void init(Time from, Time to, Locale locale) {
            String unitLabel;
            int intervalValue = to.yearsSince(from);
            if (intervalValue > 0) {
                unitLabel = CoreMsg.DATE_FORMAT_YEAR.getString(locale);
            } else {
                intervalValue = to.monthsSince(from);
                if (intervalValue > 0) {
                    unitLabel = CoreMsg.DATE_FORMAT_MONTH.getString(locale);
                } else {
                    intervalValue = to.daysSince(from);
                    if (intervalValue > 0) {
                        unitLabel = CoreMsg.DATE_FORMAT_DAY.getString(locale);
                    } else {
                        Interval difference = Time.sub(to, from);
                        intervalValue = difference.getHours();
                        if (intervalValue > 0) {
                            unitLabel = CoreMsg.DATE_FORMAT_HOUR.getString(locale);
                        } else {
                            intervalValue = difference.getMinutes();
                            if (intervalValue > 0) {
                                unitLabel = CoreMsg.DATE_FORMAT_MINUTE.getString(locale);
                            } else {
                                intervalValue = difference.getSeconds();
                                unitLabel = CoreMsg.DATE_FORMAT_SECOND.getString(locale);
                            }
                        }
                    }
                }
            }
            this.formatTime = this.isPast ? CoreMsg.DATE_FORMAT_PAST_EXPR(intervalValue, unitLabel).getString(locale) : CoreMsg.DATE_FORMAT_FUTURE_EXPR(intervalValue, unitLabel).getString(locale);
        }
    }

    private static final class Friendliest2DateFormatStyle {
        private String formatTime;

        public Friendliest2DateFormatStyle(Time time) {
            this(time, Locale.getDefault());
        }

        public Friendliest2DateFormatStyle(Time time, Locale locale) {
            this.init(time, locale);
        }

        public String toString() {
            return this.formatTime;
        }

        private void init(Time time, Locale locale) {
            Time todayEnd;
            Time nowTime = Time.now();
            Time todayBegin = Time.valueOf(nowTime.getYear(), nowTime.getMonth(), nowTime.getDay(), 0, 0, 1);
            if (time.between(todayBegin, todayEnd = Time.valueOf(nowTime.getYear(), nowTime.getMonth(), nowTime.getDay(), 23, 59, 59))) {
                this.formatTime = CoreMsg.TODAY.getString(locale);
            } else {
                Time tomorrowEnd;
                Time tomorrowBegin = Time.add(todayBegin, Interval.ONE_DAY);
                if (time.between(tomorrowBegin, tomorrowEnd = Time.add(todayEnd, Interval.ONE_DAY))) {
                    this.formatTime = CoreMsg.DATE_FORMAT_TOMORROW.getString(locale);
                } else {
                    Time yesterdayEnd;
                    Time yesterdayBegin = Time.sub(todayBegin, Interval.ONE_DAY);
                    if (time.between(yesterdayBegin, yesterdayEnd = Time.sub(todayEnd, Interval.ONE_DAY))) {
                        this.formatTime = CoreMsg.DATE_FORMAT_YESTERDAY.getString(locale);
                    } else {
                        FriendliestDateFormatStyle friendliestDateFormatStyle = new FriendliestDateFormatStyle(time, locale);
                        this.formatTime = friendliestDateFormatStyle.toString();
                    }
                }
            }
        }
    }
}

