/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.math.BigDecimal;
import org.jetbrains.annotations.NonNls;

public class Debug {
    private static boolean ignorePrevious = false;
    private static long start = -1L;
    private static long usedMemory = -1L;

    public static void setIgnorePrevious(boolean b) {
        ignorePrevious = b;
    }

    public static void end() {
        Debug.end(null);
    }

    public static DebugInfo end(String message) {
        double interval = (double)(System.currentTimeMillis() - start) / 1000.0;
        long gcStart = System.currentTimeMillis();
        System.gc();
        double gcTime = (double)(System.currentTimeMillis() - gcStart) / 1000.0;
        long memory = Debug.usedMemory();
        double inc = (double)(memory - usedMemory) / 1024.0;
        BigDecimal decimalInc = new BigDecimal(inc).setScale(inc >= 10.0 ? 0 : 2, 4);
        BigDecimal elaspedTime = new BigDecimal(interval).setScale(4, 4);
        BigDecimal elapsedGCTime = new BigDecimal(gcTime).setScale(4, 4);
        DebugInfo result = new DebugInfo(elaspedTime, elapsedGCTime, decimalInc);
        if (message != null) {
            Debug.print(message);
        }
        String formatedInc = (inc > 0.0 ? "+" : "") + decimalInc;
        String formatedMem = String.valueOf(memory / 1024L);
        Debug.print("Elapsed time: " + elaspedTime + " seconds. [totalmem: " + formatedMem + "Kb, " + formatedInc + " Kb, gc: " + elapsedGCTime + " seconds]\n");
        start = -1L;
        usedMemory = -1L;
        return result;
    }

    public static void start() {
        Debug.start(null);
    }

    public static void start(@NonNls String message) {
        if (!ignorePrevious) assert (start == -1L && usedMemory == -1L) : "Previous 'start' was not completed.";
        System.gc();
        usedMemory = Debug.usedMemory();
        if (message == null) {
            message = "Starting timer.";
        }
        Debug.print(message + " [totalmem: " + String.valueOf(usedMemory / 1024L) + "Kb]");
        start = System.currentTimeMillis();
    }

    private static void print(@NonNls String message) {
        System.out.println(message);
    }

    private static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static class DebugInfo {
        private BigDecimal elapsedGCTime;
        private BigDecimal elapsedTime;
        private BigDecimal usedMemory;

        public DebugInfo(BigDecimal elapsedTime, BigDecimal elapsedGCTime, BigDecimal usedMemory) {
            this.elapsedTime = elapsedTime;
            this.elapsedGCTime = elapsedGCTime;
            this.usedMemory = usedMemory;
        }

        public BigDecimal getElapsedGCTime() {
            return this.elapsedGCTime;
        }

        public BigDecimal getElapsedTime() {
            return this.elapsedTime;
        }

        public BigDecimal getUsedMemory() {
            return this.usedMemory;
        }
    }
}

