/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import oracle.bpm.io.ISOReader;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Base64 {
    private final int[] decode;
    private final char[] encode;
    private final char pad;
    @NonNls
    public static final String RFC1421_SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    public static final char RFC1421_PAD = '=';
    @NonNls
    public static final String FILENAME_SAFE_SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+_";
    private static final int INVALID_CHAR = -1;
    private static final int PADDING_CHAR = -2;
    public static final Base64 RFC1421_INSTANCE = new Base64('=', "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");

    public Base64(char pad, @NotNull CharSequence symbols) throws IllegalArgumentException, NullPointerException {
        if (symbols == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/util/Base64.<init> must not be null");
        }
        if (symbols == null) {
            throw new NullPointerException("symbol string is not optional");
        }
        if (symbols.length() != 64) {
            throw new IllegalArgumentException("symbol string must contain 64 characters: " + symbols.length());
        }
        this.encode = new char[64];
        this.decode = new int[128];
        this.pad = pad;
        Arrays.fill(this.decode, -1);
        int i = 0;
        int len = symbols.length();
        while (i < len) {
            char s = symbols.charAt(i);
            this.validateSymbol(s);
            this.encode[i] = s;
            this.decode[s] = i++;
        }
        this.decode[pad] = -2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static byte[] decode(@NotNull byte[] encoded) throws IllegalArgumentException {
        if (encoded == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.decode must not be null");
        }
        byte[] byArray = RFC1421_INSTANCE.decode(new ISOReader(new ByteArrayInputStream(encoded)));
        if (byArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.decode must not return null");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static byte[] decode(@NotNull String encoded) throws IllegalArgumentException {
        if (encoded == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.decode must not be null");
        }
        byte[] byArray = RFC1421_INSTANCE.decodeString(encoded);
        if (byArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.decode must not return null");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static byte[] encodeAsByteArray(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.encodeAsByteArray must not be null");
        }
        byte[] byArray = Base64.encode(data).getBytes(Charset.forName("ASCII"));
        if (byArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.encodeAsByteArray must not return null");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String encode(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.encode must not be null");
        }
        String string = RFC1421_INSTANCE.encodeString(data);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.encode must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InputStream createDecoder(@NotNull Reader in) {
        if (in == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.createDecoder must not be null");
        }
        Decoder decoder = new Decoder(in);
        if (decoder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.createDecoder must not return null");
        }
        return decoder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public OutputStream createEncoder(@NotNull Writer out) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.createEncoder must not be null");
        }
        Encoder encoder = new Encoder(out);
        if (encoder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.createEncoder must not return null");
        }
        return encoder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public byte[] decodeString(@NotNull String encoded) throws IllegalArgumentException {
        if (encoded == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.decodeString must not be null");
        }
        byte[] byArray = this.decode(new StringReader(encoded));
        if (byArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.decodeString must not return null");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String encodeString(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.encodeString must not be null");
        }
        StringWriter sw = new StringWriter((data.length + 2) / 3 * 4);
        OutputStream encoder = this.createEncoder(sw);
        try {
            encoder.write(data);
            encoder.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        String string = sw.toString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.encodeString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private byte[] decode(@NotNull Reader reader) throws IllegalArgumentException {
        byte[] byArray;
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Base64.decode must not be null");
        }
        try {
            byArray = StreamUtils.readBytes(this.createDecoder(reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error decoding characters", e);
        }
        if (byArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/util/Base64.decode must not return null");
        }
        return byArray;
    }

    private void validateSymbol(char s) throws IllegalArgumentException {
        if (s < '!' || s > '~') {
            throw new IllegalArgumentException("Symbol out of range: 0x" + Integer.toHexString(s));
        }
        if (this.decode[s] != -1) {
            throw new IllegalArgumentException("Symbol '" + s + "' is duplicate");
        }
        if (s == this.pad) {
            throw new IllegalArgumentException("Symbol '" + s + "' is also the padding character");
        }
    }

    private class Encoder
    extends OutputStream {
        private int buffer;
        private int count;
        private final Writer out;

        Encoder(Writer out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            assert (this.checkInvariants());
            int count = this.count + 2;
            Writer out = this.out;
            char[] encode = Base64.this.encode;
            out.write(encode[this.buffer | (b & 0xFF) >> count]);
            if (count == 6) {
                out.write(encode[b & 0x3F]);
                count = 0;
            }
            this.buffer = b << 6 - count & 0x3F;
            this.count = count;
        }

        @Override
        public void flush() throws IOException {
            assert (this.checkInvariants());
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            assert (this.checkInvariants());
            int count = this.count;
            Writer out = this.out;
            if (count != 0) {
                out.write(Base64.this.encode[this.buffer]);
                char pad = Base64.this.pad;
                out.write(pad);
                if (count == 2) {
                    out.write(pad);
                }
                this.buffer = 0;
                this.count = 0;
            }
            out.close();
        }

        private boolean checkInvariants() {
            int count = this.count;
            assert (count == 0 || count == 2 || count == 4) : "Unexpected count : " + count;
            int buffer = this.buffer;
            assert ((buffer & ((1 << 6 - count) - 1 | 0xFFFFFFC0)) == 0) : "Unexpected buffer : " + buffer + " - count : " + count;
            return true;
        }
    }

    private class Decoder
    extends InputStream {
        private int buffer;
        private int count;
        private final Reader in;
        private IOException lastException;

        Decoder(Reader in) {
            this.in = in;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int read() throws IOException {
            IOException lastExc = this.lastException;
            if (lastExc == null) {
                try {
                    return this.innerRead();
                }
                catch (IOException exc) {
                    this.lastException = lastExc = exc;
                }
            }
            throw lastExc;
        }

        private int innerRead() throws IOException {
            int count = this.count;
            int buffer = this.buffer;
            assert (count == 0 || count == 2 || count == 4) : "Unexpected count : " + count;
            assert ((buffer & ~((1 << count) - 1)) == 0) : "Unexpected buffer : " + buffer + " - count : " + count;
            do {
                int c;
                if ((c = this.readChar()) == -1) {
                    if (count != 0) {
                        throw new EOFException("Unexpected end of file");
                    }
                    return -1;
                }
                int b = this.decode(c);
                if (b < 0) {
                    return this.handleSpecial(b);
                }
                buffer = buffer << 6 | b;
            } while ((count += 6) < 8);
            this.buffer = buffer & (1 << (count -= 8)) - 1;
            this.count = count;
            return buffer >> count;
        }

        private int decode(int c) {
            try {
                return Base64.this.decode[c];
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                return -1;
            }
        }

        private int handleSpecial(int b) throws IOException {
            if (b == -1) {
                throw new IOException("Unexpected character");
            }
            assert (b == -2) : "Unexpected decoded char. Internal error";
            if (this.count == 0 || this.buffer != 0) {
                throw new IOException("Unexpected padding character");
            }
            if (this.count == 4 && this.readChar() != Base64.this.pad) {
                throw new IOException("Unexpected character. Expecting padding.");
            }
            this.count = 0;
            if (this.readChar() != -1) {
                throw new IOException("Unexpected character. Expecting end-of-file.");
            }
            return -1;
        }

        private int readChar() throws IOException {
            int c;
            while ((c = this.in.read()) != -1 && Character.isWhitespace(c)) {
            }
            return c;
        }
    }
}

