/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public final class BlobImpl
implements Blob,
Serializable {
    private transient byte[] bytes;
    static final long serialCheck = 8002605435617834727L;
    static final long serialVersionUID = 3626541163750430875L;

    public BlobImpl(byte[] bytes) {
        this.bytes = bytes;
    }

    public static Blob valueOf(byte[] b) {
        if (b == null) {
            return null;
        }
        return new BlobImpl(b);
    }

    @Override
    public OutputStream setBinaryStream(long pos) {
        throw new UnsupportedOperationException("Blob.setBinaryStream not supported");
    }

    @Override
    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) {
        throw new UnsupportedOperationException("Blob.setBytes not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) {
        throw new UnsupportedOperationException("Blob.setBytes not supported");
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        int from = pos > (long)this.bytes.length ? this.bytes.length : (int)pos - 1;
        int to = from + length;
        if (to > this.bytes.length) {
            to = this.bytes.length;
        }
        try {
            return Arrays.copyOfRange(this.bytes, from, to);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Invalid length:" + length, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("Invalid pos:" + pos, e);
        }
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public long position(byte[] pattern, long start) {
        throw new UnsupportedOperationException("Blob.position not supported");
    }

    @Override
    public long position(Blob pattern, long start) {
        throw new UnsupportedOperationException("Blob.position not supported");
    }

    @Override
    public void truncate(long len) {
        throw new UnsupportedOperationException("Blob.truncateetBinaryStream not supported");
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.bytes.length);
        oos.write(this.bytes);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int len = ois.readInt();
        this.bytes = new byte[len];
        ois.readFully(this.bytes);
    }
}

