/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.net.URL;
import java.util.Arrays;
import java.util.EnumMap;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.BaseMsg;
import oracle.bpm.resources.InvalidMessageException;
import oracle.bpm.resources.MessageParser;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgType;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UIMsg
extends BaseMsg {
    protected Object[] args;
    protected URL imageURL;
    private int argCount;
    @NonNls
    private static final String IMAGES_DIR = "images";
    @NonNls
    private static final String[] IMAGE_EXTS = new String[]{".css", ".jpg", ".gif", ".png", ".svg"};
    private static final long serialVersionUID = -5800800149418288359L;
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    protected UIMsg(@NotNull EnumMap<MsgType, String> message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/UIMsg.<init> must not be null");
        }
        this(message, EMPTY_ARRAY);
    }

    protected UIMsg(@NotNull EnumMap<MsgType, String> message, @NotNull Object[] arguments) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/UIMsg.<init> must not be null");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/UIMsg.<init> must not be null");
        }
        super(message);
        this.args = arguments;
        this.argCount = 0;
    }

    public static Msg QUOTE(String s) {
        return TMsg.QUOTE.args(s);
    }

    public int getArgCount() {
        return this.argCount;
    }

    public String getImageFile() {
        return this.getMsgByType(MsgType.IMAGE);
    }

    public URL getImageResource() {
        this.checkState();
        URL resource = this.imageURL;
        if (resource == null && this.hasImage()) {
            String imageFile = this.getMsgByType(MsgType.IMAGE);
            resource = this.bundle.getResource("images/" + imageFile);
            if (resource == null) {
                CoreMsg.CANT_LOAD_IMAGE(this.bundle, imageFile).logWarning();
                this.clearMsgType(MsgType.IMAGE);
            }
            this.imageURL = resource;
        }
        return resource;
    }

    public boolean hasImage() {
        return this.hasMsgType(MsgType.IMAGE);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof UIMsg && this.equals((UIMsg)o);
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + this.args.hashCode();
    }

    public int compareTo(Msg msg) {
        return super.compareTo(msg);
    }

    public String getNonLocalizedString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getBundleShortName());
        result.append('.');
        result.append(this.code);
        for (Object arg : this.args) {
            result.append(',');
            result.append(String.valueOf(arg));
        }
        return result.toString();
    }

    @Override
    protected void setMsgByType(@NotNull MsgType type, @NotNull String value) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/UIMsg.setMsgByType must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/UIMsg.setMsgByType must not be null");
        }
        if (type == MsgType.IMAGE && value.length() > 0) assert (this.isValidImage(value)) : "Invalid image file : '" + value + "'";
        super.setMsgByType(type, value);
    }

    @Override
    protected void parseMsg(boolean allowArguments) {
        MessageParser parser = new MessageParser();
        for (MsgType msgType : MsgType.values()) {
            if (!this.hasMsgType(msgType)) continue;
            String msg = this.getMsgByType(msgType);
            this.setMsgByType(msgType, parser.parse(msg, allowArguments));
            int count = parser.getArgCount();
            if (!this.hasMsgType(msgType) || !parser.isValid() || count > 0 && !allowArguments) {
                throw new InvalidMessageException(this.bundle, this.code, msg);
            }
            if (count <= this.argCount) continue;
            this.argCount = count;
        }
    }

    private boolean isValidImage(@NotNull String imageFile) {
        if (imageFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/UIMsg.isValidImage must not be null");
        }
        boolean result = false;
        String fileName = imageFile.toLowerCase();
        for (String extension : IMAGE_EXTS) {
            if (!fileName.endsWith(extension)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean equals(UIMsg that) {
        return super.equals(that) && Arrays.equals(this.args, that.args);
    }
}

