/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.util.EnumMap;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorMsg
extends Msg {
    private int errorCode;
    private static final long serialVersionUID = -7518473402343292544L;
    private static final String DEFAULT_SEVERITY = "000";

    protected ErrorMsg(@NotNull EnumMap<MsgType, String> message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/ErrorMsg.<init> must not be null");
        }
        this(message, EMPTY_ARRAY);
    }

    protected ErrorMsg(@NotNull EnumMap<MsgType, String> message, @NotNull Object[] arguments) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/ErrorMsg.<init> must not be null");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/ErrorMsg.<init> must not be null");
        }
        super(message, arguments);
        if (!this.hasMsgType(MsgType.ERROR_SEVERITY)) {
            this.setMsgByType(MsgType.ERROR_SEVERITY, DEFAULT_SEVERITY);
        }
    }

    @Override
    public String getString(@Nullable MsgType type, LocaleSupport locale) {
        if (type == null) {
            type = MsgType.DEFAULT;
        }
        String result = super.getString(type, locale);
        if (type == MsgType.DEFAULT) {
            String msg = super.getString(MsgType.ERROR_CAUSE, locale);
            if (msg != null && !msg.isEmpty()) {
                result = result + String.format(".  %s: %s", CoreMsg.CAUSE, msg);
            }
            if ((msg = super.getString(MsgType.ERROR_ACTION, locale)) != null && !msg.isEmpty()) {
                result = result + String.format(".  %s: %s", CoreMsg.ACTION, msg);
            }
            if (this.getErrorCode() != 0) {
                result = String.format("BPM-%d: %s", this.getErrorCode(), result);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getCause() {
        String string = super.getString(MsgType.ERROR_CAUSE, Msg.getThreadLocaleSupport());
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/resources/ErrorMsg.getCause must not return null");
        }
        return string;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void logFatal() {
        Log.logFatal(this);
    }

    protected void setErrorCode(int id) {
        this.errorCode = id;
    }
}

