/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.oparser;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.oparser.Option;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public abstract class OptionParser {
    private StringList arguments = null;
    private boolean exitOnStopParsing = true;
    private List<Option> optional = null;
    private List<Option> options = null;
    private List<Option> optionsWithParameters = null;
    private List<Option> required = null;
    @NonNls
    private static final String STRING_VALUE = "<string>";
    @NonNls
    private static final String VALUE = "<value>";
    @NonNls
    private static final String NEG_PREFIX = "no-";

    protected OptionParser(String[] args) {
        this.arguments = StringList.create(args);
    }

    public abstract String getAppName();

    public void setExitOnStopParsing(boolean exitOnStopParsing) {
        this.exitOnStopParsing = exitOnStopParsing;
    }

    public final Option<Boolean> addOption(char letter, String name, String description, boolean defaultValue) {
        return this.addOption(Boolean.class, letter, name, description, defaultValue);
    }

    public final Option<Integer> addOption(char letter, String name, String description, int defaultValue) {
        return this.addOption(Integer.class, letter, name, description, defaultValue);
    }

    public final <T> Option<T> addArgument(Class<T> type, String name, String description, boolean required) {
        this.init();
        Option<Object> opt = new Option<Object>(this, type, ' ', name, description, null);
        if (required) {
            this.required.add(opt);
        } else {
            this.optional.add(opt);
        }
        this.options.add(opt);
        return opt;
    }

    public final Option<String> addArgument(String name, boolean required) {
        return this.addArgument(String.class, name, null, required);
    }

    public final Option<String> addArgument(String name, String description, boolean required) {
        return this.addArgument(String.class, name, description, required);
    }

    public final Option<String> addOption(char letter, String name, String description) {
        return this.addOption(String.class, letter, name, description, null);
    }

    public final Option<String> addOption(char letter, String name, String description, String defaultValue) {
        return this.addOption(String.class, letter, name, description, defaultValue);
    }

    public StringList parse() {
        int i;
        int j = 0;
        block0: for (i = 0; i < this.arguments.size(); ++i) {
            boolean negation;
            String arg = (String)this.arguments.get(i);
            int curr = 0;
            boolean longOpt = false;
            if (arg.charAt(curr) != '-') break;
            if (arg.charAt(++curr) == '-') {
                if (curr == arg.length() - 1 || Character.isWhitespace(arg.charAt(++curr))) {
                    ++i;
                    break;
                }
                longOpt = true;
            }
            if (arg.startsWith(NEG_PREFIX, curr)) {
                curr += NEG_PREFIX.length();
                negation = true;
            } else {
                negation = false;
            }
            if (longOpt) {
                for (Option opt : this.optionsWithParameters) {
                    if (!opt.getName().equals(arg.substring(curr))) continue;
                    if (opt.isBoolean()) {
                        opt.execute(negation);
                        continue block0;
                    }
                    if (negation) {
                        Msg msg = CoreMsg.NONBOOLNEG(String.valueOf(opt.getLetter()), opt.getName());
                        this.printError(msg);
                        this.stopParsing();
                    }
                    if (i == this.arguments.size() - 1) {
                        this.printError(CoreMsg.EXPECTEDARG(String.valueOf(opt.getLetter()), opt.getName()));
                        this.stopParsing();
                    }
                    opt.execute(negation, (String)this.arguments.get(++i));
                    continue block0;
                }
            } else {
                if (curr >= arg.length()) {
                    this.printError(CoreMsg.INVOPT(arg));
                    this.stopParsing();
                }
                block2: while (curr++ < arg.length()) {
                    for (Option opt : this.optionsWithParameters) {
                        if (opt.getLetter() != arg.charAt(curr - 1)) continue;
                        if (!opt.isBoolean()) {
                            if (negation) {
                                this.printError(CoreMsg.NONBOOLNEG(String.valueOf(opt.getLetter()), opt.getName()));
                                this.stopParsing();
                            }
                            if (arg.charAt(curr - 2) != '-') {
                                this.printError(CoreMsg.CANTCOMBINE);
                            }
                            if (curr < arg.length()) {
                                this.printError(CoreMsg.SEPOPT(String.valueOf(opt.getLetter()), opt.getName()));
                                arg = arg.substring(curr);
                            } else if (i == this.arguments.size() - 1) {
                                this.printError(CoreMsg.EXPECTEDARG(opt.getLetter() + "", opt.getName()));
                                this.stopParsing();
                            } else {
                                arg = (String)this.arguments.get(++i);
                            }
                            opt.execute(negation, arg);
                            continue block0;
                        }
                        opt.execute(negation);
                        continue block2;
                    }
                }
            }
            if (j != this.optionsWithParameters.size()) continue;
            this.printError(CoreMsg.INVOPT(arg));
            this.stopParsing();
        }
        for (Option opt : this.required) {
            if (this.arguments.size() <= i) {
                this.printHelp();
            }
            opt.execute(false, (String)this.arguments.get(i++));
        }
        for (Option opt : this.optional) {
            if (this.arguments.size() <= i) break;
            opt.execute(false, (String)this.arguments.get(i++));
        }
        return StringList.create(this.arguments.subList(i, this.arguments.size()));
    }

    public void printHelp() {
        boolean hasCmdLineOpt = false;
        String msg = " " + this.getAppName() + " " + CoreMsg.OPT_IN_BRACKETS.toString();
        for (Option opt : this.required) {
            msg = msg + " " + opt.getName();
            if (opt.getDescription() == null) continue;
            hasCmdLineOpt = true;
        }
        for (Option opt : this.optional) {
            msg = msg + " [" + opt.getName() + "]";
            if (opt.getDescription() == null) continue;
            hasCmdLineOpt = true;
        }
        if (hasCmdLineOpt) {
            msg = msg + "\n" + CoreMsg.WHERE;
            for (Option opt : this.required) {
                msg = msg + "\n  " + opt.getName() + ": " + opt.getDescription();
            }
            for (Option opt : this.optional) {
                msg = msg + "\n  " + opt.getName() + ": " + opt.getDescription();
            }
        }
        msg = msg + "\n" + CoreMsg.OPTIONS + "\n";
        for (Option opt : this.optionsWithParameters) {
            String ops = opt.isBoolean() ? "" : (opt.isString() ? STRING_VALUE : VALUE);
            msg = msg + "  -" + opt.getLetter() + ", --" + opt.getName() + " " + ops + ": " + opt.getDescription() + "\n";
        }
        this.print(msg);
        System.exit(0);
    }

    private void printError(Msg msg) {
        System.err.println(msg.getString());
    }

    private void print(String msg) {
        System.err.println(msg);
    }

    private <T> Option<T> addOption(Class<T> type, char letter, String name, String description, T defaultValue) {
        this.init();
        Option<T> opt = new Option<T>(this, type, letter, name, description, defaultValue);
        this.optionsWithParameters.add(opt);
        this.options.add(opt);
        return opt;
    }

    private void init() {
        if (this.optionsWithParameters == null) {
            this.optionsWithParameters = new ArrayList<Option>();
            this.required = new ArrayList<Option>();
            this.optional = new ArrayList<Option>();
            this.options = new ArrayList<Option>();
            Option<Boolean> helpOption = new Option<Boolean>(this, Boolean.class, 'h', "help", CoreMsg.HELP.toString(), null){

                @Override
                public void execute(boolean negated) {
                    if (!negated) {
                        OptionParser.this.printHelp();
                    }
                }
            };
            this.optionsWithParameters.add(helpOption);
            this.options.add(helpOption);
        }
    }

    private void stopParsing() {
        if (!this.exitOnStopParsing) {
            throw new RuntimeException();
        }
        System.exit(1);
    }
}

