/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.observers;

import java.util.List;
import java.util.Map;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.observers.ObservableObject;

public abstract class ObservableObjectImpl
implements ObservableObject {
    private Map<String, List<ObjectPropertyListener>> observers = CollectionFactory.createMap();
    private Map<String, List<ObjectRelationListener>> relationObservers = CollectionFactory.createMap();

    @Override
    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getPropertyObservers(propertyName).add(observer);
    }

    @Override
    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getPropertyObservers(propertyName).remove(observer);
    }

    @Override
    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).add(observer);
    }

    @Override
    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).remove(observer);
    }

    protected void firePropertyChanged(String propertyName) {
        for (ObjectPropertyListener observer : this.getPropertyObservers(propertyName)) {
            observer.propertyChanged(this, propertyName);
        }
    }

    protected void fireRelationAdded(String relationName) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            observer.relationAdded(this, relationName);
        }
    }

    protected void fireRelationRemoved(String relationName) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            observer.relationRemoved(this, relationName);
        }
    }

    protected List<ObjectPropertyListener> getPropertyObservers(String propertyName) {
        if (!this.observers.containsKey(propertyName)) {
            this.observers.put(propertyName, CollectionFactory.createList());
        }
        return this.observers.get(propertyName);
    }

    protected List<ObjectRelationListener> getRelationsObservers(String relationName) {
        if (!this.relationObservers.containsKey(relationName)) {
            this.relationObservers.put(relationName, CollectionFactory.createList());
        }
        return this.relationObservers.get(relationName);
    }
}

