/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.log;

import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public enum LogComponent {
    DEFAULT("oracle.bpm.common");

    private final String id;
    private final Logger logger;

    private LogComponent(String id) {
        this.id = id;
        this.logger = Logger.getLogger(id);
    }

    public String id() {
        return this.id;
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LogComponent findLogComponent(String className) {
        int lastDot = className.lastIndexOf(46);
        String pkg = lastDot != -1 ? className.substring(0, lastDot) : className;
        LogComponent result = DEFAULT;
        for (LogComponent component : LogComponent.values()) {
            if (component.id().length() <= result.id.length() || !pkg.startsWith(component.id())) continue;
            result = component;
        }
        LogComponent logComponent = result;
        if (logComponent == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/log/LogComponent.findLogComponent must not return null");
        }
        return logComponent;
    }
}

