/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.TimeZone;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TZTime {
    @NotNull
    private final Time time;
    @Nullable
    private final TimeZone tz;

    TZTime(@NotNull Time time, @Nullable Integer offset) {
        if (time == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/TZTime.<init> must not be null");
        }
        this.time = time;
        this.tz = TZTime.getTimeZone(offset);
    }

    public static TZTime valueOf(@NotNull String timeStr) {
        if (timeStr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/TZTime.valueOf must not be null");
        }
        return Time.parseTZ(timeStr);
    }

    public String toXMLString() {
        TimeZone tz = this.tz;
        if (tz == null) {
            return TZTime.trimTZ(this.time.toXMLString());
        }
        TimeZone sv = Time.getTimeZone();
        boolean equalZones = this.equals(tz, sv);
        if (!equalZones) {
            Time.setTimeZone(tz);
        }
        String result = this.time.toXMLString();
        if (!equalZones) {
            Time.setTimeZone(sv);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Time getTime() {
        Time time = this.time;
        if (time == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/TZTime.getTime must not return null");
        }
        return time;
    }

    public String toString() {
        int tzIndex;
        String str = this.toXMLString();
        int pos = str.indexOf(84);
        assert (pos != -1);
        String datePart = str.substring(0, pos);
        String timePart = str.substring(pos + 1);
        if ("1970-01-01".equals(datePart)) {
            str = timePart;
        } else if (!"00:00:00".equals(timePart)) {
            str = datePart + ' ' + timePart;
        } else {
            return datePart;
        }
        int n = tzIndex = this.tz == null ? str.length() : TZTime.tzPos(str);
        if (":00".equals(str.substring(tzIndex - 3, tzIndex))) {
            str = str.substring(0, tzIndex - 3) + str.substring(tzIndex);
        }
        return str;
    }

    private static TimeZone getTimeZone(@Nullable Integer offset) {
        return offset == null ? null : TimeZone.getTimeZone(TZTime.getTZID(offset));
    }

    private static String trimTZ(String dateTime) {
        return dateTime.substring(0, TZTime.tzPos(dateTime));
    }

    private static int tzPos(String dateTime) {
        int last = dateTime.length() - 1;
        if (dateTime.charAt(last) == 'Z') {
            return last;
        }
        int pos = last - 5;
        assert (dateTime.charAt(pos) == '-' || dateTime.charAt(pos) == '+');
        return pos;
    }

    private static String getTZID(int offset) {
        char sign;
        StringBuilder tzID = new StringBuilder("GMT");
        if ((offset /= 60000) < 0) {
            sign = '-';
            offset = -offset;
        } else {
            sign = '+';
        }
        tzID.append(sign);
        Str.append(tzID, offset / 60, 2, 10, '0');
        tzID.append(':');
        Str.append(tzID, offset % 60, 2, 10, '0');
        return tzID.toString();
    }

    private boolean equals(TimeZone tz1, TimeZone tz2) {
        long millis = this.time.getMilliSeconds();
        return tz2.getOffset(millis) == tz1.getOffset(millis);
    }
}

