/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class SuspendableThreadLocal<T>
extends ThreadLocal<T> {
    private static Set<SuspendableThreadLocal> registredThreadLocal = Collections.synchronizedSet(new WeakHashSet());

    public SuspendableThreadLocal() {
        registredThreadLocal.add(this);
    }

    public static SuspendableThreadLocal[] getAllSuspendableThreadLocal() {
        return registredThreadLocal.toArray(new SuspendableThreadLocal[registredThreadLocal.size()]);
    }

    public static SuspendedInfo suspendCurrentThread() {
        SuspendableThreadLocal[] threadLocals;
        SuspendedInfo info = new SuspendedInfo();
        for (SuspendableThreadLocal threadLocal : threadLocals = SuspendableThreadLocal.getAllSuspendableThreadLocal()) {
            if (threadLocal == null) continue;
            info.threadLocalValues.put(threadLocal, threadLocal.get());
            SuspendableThreadLocal.resetThreadLocal(threadLocal);
        }
        return info;
    }

    public static void resumeCurrentThread(SuspendedInfo info) {
        for (Map.Entry entry : info.threadLocalValues.entrySet()) {
            SuspendableThreadLocal threadLocal = (SuspendableThreadLocal)entry.getKey();
            Object value = entry.getValue();
            threadLocal.set(value);
        }
    }

    private static <T> void resetThreadLocal(SuspendableThreadLocal<T> threadLocal) {
        threadLocal.set(threadLocal.initialValue());
    }

    private static class WeakHashSet<E>
    extends AbstractSet<E>
    implements Set<E> {
        private final Map<E, Object> map = new WeakHashMap<E, Object>();
        private static final Object PRESENT = new Object();

        private WeakHashSet() {
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean add(E o) {
            return this.map.put(o, PRESENT) == null;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) == PRESENT;
        }

        @Override
        public Iterator<E> iterator() {
            return this.map.keySet().iterator();
        }
    }

    public static class SuspendedInfo {
        private Map<SuspendableThreadLocal, Object> threadLocalValues = new HashMap<SuspendableThreadLocal, Object>();
    }
}

