/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.util.DateFormatSymbolUtils;

@Component(module="Fuego.Lang")
public enum Month implements I18nProvider
{
    JANUARY(31),
    FEBRUARY(29),
    MARCH(31),
    APRIL(30),
    MAY(31),
    JUNE(30),
    JULY(31),
    AUGUST(31),
    SEPTEMBER(30),
    OCTOBER(31),
    NOVEMBER(30),
    DECEMBER(31);

    private int days;

    private Month(int days) {
        this.days = days;
    }

    public int days(int year) {
        return this == FEBRUARY && (year % 4 != 0 || year % 100 == 0 && year % 400 != 0) ? this.days - 1 : this.days;
    }

    public Month next() {
        Month[] months = Month.values();
        return months[(this.ordinal() + 1) % months.length];
    }

    public Month prev() {
        Month[] months = Month.values();
        int len = months.length;
        return months[(this.ordinal() + len - 1) % len];
    }

    public int intValue() {
        return this.ordinal() + 1;
    }

    public static Month valueOf(int monthNumber) {
        try {
            return Month.values()[monthNumber - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("monthNumber: " + monthNumber);
        }
    }

    @Override
    public String getString() {
        return this.getString(Locale.getDefault());
    }

    @Override
    public String getString(Locale locale) {
        return DateFormatSymbolUtils.getLocalizedMonthNames(locale)[this.ordinal()];
    }

    public String getShortString() {
        return this.getShortString(Locale.getDefault());
    }

    public String getShortString(Locale locale) {
        return DateFormatSymbolUtils.getLocalizedMonthShortNames(locale)[this.ordinal()];
    }

    @Exclude
    public static Month compatibleValueOf(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int index = Integer.parseInt(name) - 1;
            Month[] months = Month.values();
            return index >= 0 && index < months.length ? months[index] : null;
        }
        return Month.valueOf(name);
    }

    public static void main(String[] args) {
        for (String arg : args) {
            Month month = Month.valueOf(arg);
            System.out.println("month = " + month);
            System.out.println("month = " + month.getString() + ' ' + month.getShortString());
            Locale es = new Locale("ES");
            System.out.println("mes = " + month.getString(es) + ' ' + month.getShortString(es));
            System.out.println("days(1900) = " + month.days(1900));
            System.out.println("days(1996) = " + month.days(1996));
            System.out.println("days(2000) = " + month.days(2000));
            System.out.println("days(2001) = " + month.days(2001));
        }
    }
}

