/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import org.jetbrains.annotations.NonNls;

public abstract class Invokeable
implements InvocationHandler,
Serializable {
    protected String fuegoName;
    protected Invokeable heir;
    protected Map<String, Object> resources;
    @NonNls
    private static final String RETURN_SIGNATURE = "#R";
    public static final int NO_INDEX = -1;
    static final long serialVersionUID = -6283646072541637940L;
    static final long serialCheck = -4455295501317427483L;

    public abstract void setAttributeValue(String var1, int var2, Object var3);

    public abstract Object getAttributeValue(String var1, String var2, int var3);

    public abstract String getName();

    public abstract Object invoke(@NonNls String var1, Object ... var2) throws ComponentExecutionException, InvocationTargetException;

    public static boolean isInstanceOf(Object obj, String componentType, String signature) {
        boolean isInstance = false;
        if (obj instanceof RuntimeCILExecutionException) {
            RuntimeCILExecutionException re = (RuntimeCILExecutionException)obj;
            obj = re.getObject();
        }
        if (obj instanceof Invokeable) {
            Invokeable inv = (Invokeable)obj;
            isInstance = inv.isInstanceOf(componentType, signature);
        }
        return isInstance;
    }

    public Object setAttributeValue(String signature, Object value) {
        this.setAttributeValue(signature, -1, value);
        return value;
    }

    public Object getAttributeValue(String signature) {
        return this.getAttributeValue(signature, null, -1);
    }

    public Object getAttributeValue(String signature, String setter) {
        return this.getAttributeValue(signature, setter, -1);
    }

    public Object getAttributeValue(String signature, int index) {
        return this.getAttributeValue(signature, null, index);
    }

    public void setFuegoName(String qualifiedName) {
        this.fuegoName = qualifiedName;
    }

    public String getFuegoName() {
        return this.fuegoName;
    }

    public void setHeir(Invokeable heir) {
        this.heir = heir;
    }

    public Invokeable getHeir() {
        return this.heir;
    }

    public final Object getResource(String name) {
        return this.resources != null ? this.resources.get(name) : null;
    }

    public final Map<String, Object> getResources() {
        if (this.resources == null) {
            this.resources = new HashMap<String, Object>();
        }
        return this.resources;
    }

    public Object getTarget() {
        return DynamicObject.NULL;
    }

    public Object getType() {
        return null;
    }

    public final <T> T asInterface(Class<T> interf) {
        return interf.cast(this.asInterface(new Class[]{interf}));
    }

    public final Object asInterface(Class[] interf) {
        return Proxy.newProxyInstance(interf[0].getClassLoader(), interf, (InvocationHandler)this);
    }

    public boolean isInstanceOf(String componentType, String signature) {
        return false;
    }

    public Object invoke(String methodSignature, boolean synchronous, Object[] inputArgs, Object[] outputArgs) throws ComponentExecutionException, Exception {
        return this.invokeDynamic(methodSignature, synchronous, inputArgs, outputArgs);
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        String signature = JavaClass.getSignature(method);
        try {
            return this.invoke(signature, args);
        }
        catch (ComponentExecutionException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDynamic(String methodSignature, boolean synchronous, Object[] inputArgs, Object[] outputArgs) throws Exception {
        Time start = null;
        try {
            if (this.isTracing()) {
                start = Time.now();
                this.beginTrace(methodSignature, this.getName(), start);
            }
            Object object = this.invokeImpl(methodSignature, synchronous, inputArgs, outputArgs);
            return object;
        }
        finally {
            if (start != null) {
                this.endTrace(methodSignature, this.getName(), start);
            }
        }
    }

    public void invokeRelayTo(String methodSignature, Object[] inputArguments, Object target, String targetMtd, Object[] bindings) throws Exception {
        throw new UnsupportedOperationException();
    }

    public final void putResource(String name, Object resource) {
        this.getResources().put(name, resource);
    }

    public final void putResources(Map<String, Object> map) {
        this.resources = map;
    }

    protected boolean isTracing() {
        return false;
    }

    protected void beginTrace(String method, String component, Time started) {
    }

    protected void endTrace(String method, String component, Time start) {
    }

    protected Object invokeImpl(String methodSignature, boolean synchronous, Object[] inputArgs, Object[] outputArgs) throws ComponentExecutionException, Exception {
        try {
            Object[] methodArgs = this.processInputArguments(methodSignature, inputArgs, outputArgs);
            this.processInputHolders(methodSignature, methodArgs);
            Object ret = this.invoke(methodSignature, methodArgs);
            this.processOutputHolders(methodSignature, methodArgs);
            return this.processOutputArguments(methodSignature, methodArgs, outputArgs, ret);
        }
        catch (InvocationTargetException e) {
            String name = JavaClass.getMethodNameFromSignature(methodSignature);
            throw new ComponentExecutionException(e, this.getTarget().getClass().getName(), name);
        }
        catch (Exception e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            throw e;
        }
    }

    protected final Object[] processInputArguments(String methodSignature, Object[] inputArgs, Object[] outputArgs) {
        int argno;
        String signature;
        int i;
        if (inputArgs == null) {
            return null;
        }
        int max = -1;
        int length = inputArgs.length;
        for (i = 0; i < length; i += 2) {
            signature = (String)inputArgs[i];
            if (signature.charAt(0) != '#' || (argno = Integer.parseInt(signature.substring(1))) <= max) continue;
            max = argno;
        }
        if (outputArgs != null) {
            for (i = 0; i < outputArgs.length; ++i) {
                signature = (String)outputArgs[i];
                assert (signature != null) : "Null signature for output argument #" + i;
                if (signature.charAt(0) != '#' || signature.equals(RETURN_SIGNATURE) || (argno = Integer.parseInt(signature.substring(1))) <= max) continue;
                max = argno;
            }
        }
        Object[] result = max == -1 ? null : new Object[max + 1];
        for (int i2 = 0; i2 < inputArgs.length; i2 += 2) {
            String signature2 = (String)inputArgs[i2];
            Object value = inputArgs[i2 + 1];
            if (signature2.charAt(0) == '#' && result != null) {
                result[Integer.parseInt((String)signature2.substring((int)1))] = value;
                continue;
            }
            this.setAttributeValue(signature2, value);
        }
        return result;
    }

    protected void processInputHolders(String methodSignature, Object[] methodArgs) throws Exception {
    }

    protected final Object processOutputArguments(String methodSignature, Object[] methodArgs, Object[] outputArgs, Object ret) {
        if (outputArgs != null) {
            for (int i = 0; i < outputArgs.length; ++i) {
                String sig = (String)outputArgs[i];
                if (RETURN_SIGNATURE.equals(sig)) {
                    outputArgs[i] = ret;
                    continue;
                }
                if (sig.charAt(0) == '#') {
                    int index = Integer.parseInt(sig.substring(1));
                    outputArgs[i] = methodArgs[index];
                    continue;
                }
                outputArgs[i] = this.getAttributeValue(sig);
            }
        }
        return ret;
    }

    protected void processOutputHolders(String methodSignature, Object[] methodArgs) throws Exception {
    }
}

