/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.TypeException;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public final class IllegalConversionException
extends TypeException {
    static final long serialVersionUID = -1401216778338847875L;
    static final long serialCheck = -6219801980066625290L;

    public IllegalConversionException(String from, String to) {
        super(CoreMsg.ILLCONV(from, to));
    }

    public IllegalConversionException(Object o1, String s) {
        this(o1 + "(" + o1.getClass().getName() + ")", s);
    }

    public IllegalConversionException(Object o1, Object o2) {
        this(o1, o2.getClass().getName());
    }

    public IllegalConversionException(String s1, String s2, String details) {
        super(CoreMsg.ILLCONVD(s1, s2, details));
    }

    public IllegalConversionException(Object o1, String s, String details) {
        super(CoreMsg.ILLCONVD(o1.getClass().getName(), s, details));
    }

    public IllegalConversionException(Object o1, String s, Throwable details) {
        super(CoreMsg.ILLCONVD(o1.getClass().getName(), s, details.getClass().getName() + ":" + details.getMessage()));
    }

    private IllegalConversionException(Msg details) {
        super(details);
    }

    public static IllegalConversionException createBinaryError(Throwable details) {
        return new IllegalConversionException(CoreMsg.BINARY_CONV_ERROR(details.getClass().getName() + ":" + details.getMessage()));
    }

    public static IllegalConversionException createLengthExceededException(Number value, int length) {
        return new IllegalConversionException(CoreMsg.DECIMAL_EXLENGTH(value, length));
    }
}

