/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.IOException;
import java.io.OutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import oracle.bpm.lang.PreferenceException;
import oracle.bpm.lang.PreferenceNode;
import oracle.bpm.lang.PreferencesService;

public class DefaultPreferencesService
implements PreferencesService {
    private PreferenceNode root;
    private PreferenceNode systemRoot;

    @Override
    public PreferenceNode getRootNode() {
        if (this.root == null) {
            this.root = new Node(Preferences.userRoot());
        }
        return this.root;
    }

    @Override
    public PreferenceNode getSystemRootNode() {
        if (this.systemRoot == null) {
            this.systemRoot = new Node(Preferences.systemRoot());
        }
        return this.systemRoot;
    }

    private static class Node
    implements PreferenceNode {
        private Preferences prefs;

        Node(Preferences prefs) {
            this.prefs = prefs;
        }

        @Override
        public boolean getBoolean(String key) {
            return this.prefs.getBoolean(key, false);
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            return this.prefs.getBoolean(key, defaultValue);
        }

        @Override
        public int getInt(String key) {
            return this.prefs.getInt(key, 0);
        }

        @Override
        public int getInt(String key, int defaultValue) {
            return this.prefs.getInt(key, defaultValue);
        }

        @Override
        public String absolutePath() {
            return this.prefs.absolutePath();
        }

        @Override
        public PreferenceNode child(String name) {
            Preferences node = this.prefs.node(name);
            return new Node(node);
        }

        @Override
        public boolean childExists(String name) {
            try {
                return this.prefs.nodeExists(name);
            }
            catch (BackingStoreException e) {
                return false;
            }
        }

        @Override
        public String[] childrenNames() {
            try {
                return this.prefs.childrenNames();
            }
            catch (BackingStoreException e) {
                return new String[0];
            }
        }

        @Override
        public void clear() throws PreferenceException {
            try {
                this.prefs.clear();
            }
            catch (BackingStoreException e) {
                throw new PreferenceException(e);
            }
        }

        @Override
        public void exportNode(OutputStream os) throws PreferenceException {
            try {
                this.prefs.exportNode(os);
            }
            catch (BackingStoreException e) {
                throw new PreferenceException(e);
            }
            catch (IOException e) {
                throw new PreferenceException(e);
            }
        }

        @Override
        public void flush() {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }

        @Override
        public String get(String key) {
            return this.prefs.get(key, null);
        }

        @Override
        public String get(String key, String defaultValue) {
            return this.prefs.get(key, defaultValue);
        }

        @Override
        public void put(String key, String value) {
            this.prefs.put(key, value);
        }

        @Override
        public void put(String key, long value) {
            this.prefs.putLong(key, value);
        }

        @Override
        public void put(String key, boolean value) {
            this.prefs.putBoolean(key, value);
        }

        @Override
        public void remove() throws PreferenceException {
            try {
                this.prefs.removeNode();
            }
            catch (BackingStoreException e) {
                throw new PreferenceException(e);
            }
        }
    }
}

