/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.EnumSet;
import java.util.Locale;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Kind;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum CompOperator implements I18nProvider
{
    EQ(CoreMsg.EQ){

        @Override
        public String getSymbol() {
            return "=";
        }

        @Override
        public CompOperator negate() {
            return NE;
        }
    }
    ,
    NE(CoreMsg.NE){

        @Override
        public String getSymbol() {
            return "/=";
        }

        @Override
        public CompOperator negate() {
            return EQ;
        }
    }
    ,
    GT(CoreMsg.GT){

        @Override
        public String getSymbol() {
            return ">";
        }

        @Override
        public CompOperator negate() {
            return LE;
        }
    }
    ,
    LT(CoreMsg.LT){

        @Override
        public String getSymbol() {
            return "<";
        }

        @Override
        public CompOperator negate() {
            return GE;
        }
    }
    ,
    GE(CoreMsg.GE){

        @Override
        public String getSymbol() {
            return ">=";
        }

        @Override
        public CompOperator negate() {
            return LT;
        }
    }
    ,
    LE(CoreMsg.LE){

        @Override
        public String getSymbol() {
            return "<=";
        }

        @Override
        public CompOperator negate() {
            return GT;
        }
    }
    ,
    NOT_BETWEEN(CoreMsg.NOT_BETWEEN){

        @Override
        public String getSymbol() {
            return "!<>";
        }

        @Override
        public CompOperator negate() {
            return BETWEEN;
        }
    }
    ,
    BETWEEN(CoreMsg.BETWEEN){

        @Override
        public String getSymbol() {
            return "<>";
        }

        @Override
        public CompOperator negate() {
            return NOT_BETWEEN;
        }
    }
    ,
    LIKE(CoreMsg.LIKE){

        @Override
        public String getSymbol() {
            return "like";
        }

        @Override
        public CompOperator negate() {
            return NOT_LIKE;
        }
    }
    ,
    NOT_LIKE(CoreMsg.NOT_LIKE){

        @Override
        public CompOperator negate() {
            return LIKE;
        }

        @Override
        public String getSymbol() {
            return "not like";
        }
    };

    private transient Msg msg;

    private CompOperator(Msg msg) {
        this.msg = msg;
    }

    public abstract CompOperator negate();

    public abstract String getSymbol();

    @Exclude
    public Msg getMsg() {
        return this.msg;
    }

    public boolean isTernary() {
        return this == BETWEEN || this == NOT_BETWEEN;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public static CompOperator fromSymbol(String oper) {
        for (CompOperator v : CompOperator.values()) {
            if (!v.getSymbol().equalsIgnoreCase(oper)) continue;
            return v;
        }
        return null;
    }

    public static EnumSet<CompOperator> fromKind(int kind) {
        EnumSet<Object> result = Kind.isNumber(kind) || kind == 6 ? EnumSet.of(EQ, new CompOperator[]{NE, LT, LE, GE, GT, BETWEEN, NOT_BETWEEN}) : EnumSet.of(EQ, NE);
        return result;
    }
}

