/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.LockOwner;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;

@Component(module="Fuego.Internal")
public class Cache<K, V>
implements Serializable,
Map<K, V> {
    private transient int clock;
    private Entry<K, V>[] elements;
    private transient int lockCount;
    private transient HashMap<K, Entry<K, V>> map;
    static final long serialVersionUID = 5861731866643296888L;
    static final long serialCheck = 1829649318101383543L;

    public Cache() {
        this(100);
    }

    public Cache(int capacity) {
        this.map = new HashMap(capacity);
        this.elements = (Entry[])Cast.force(new Entry[capacity]);
        for (int i = 0; i < capacity; ++i) {
            this.elements[i] = new Entry();
        }
    }

    public static void main(String[] args) {
        Cache<String, String> c = Cache.create(3);
        c.put("a", "AAAAAAAAA");
        System.out.println(c);
        c.put("b", "BBBBB");
        System.out.println(c);
        c.put("c", "CCCCC");
        System.out.println(c);
        c.put("d", "DDDDD");
        System.out.println(c);
        c.put("d", "DEEEEE");
        System.out.println(c);
        System.out.println((String)c.get("a"));
        c.put("e", "EEEEE");
        System.out.println(c);
        c.put("f", "FFFF");
        System.out.println(c);
    }

    public static <V, K> Cache<K, V> create(int capacity) {
        return new Cache<K, V>(capacity);
    }

    public final int getCapacity() {
        return this.elements.length;
    }

    @Exclude
    public V getLocked(K key, LockOwner owner) throws AlreadyLockedException {
        Entry<K, V> entry = this.getEntry(key, true);
        V result = null;
        if (entry != null) {
            if (entry.locked == null) {
                entry.locked = owner;
                ++this.lockCount;
            } else if (!owner.equals(entry.locked)) {
                throw new AlreadyLockedException(entry.value, entry.locked);
            }
            result = entry.value;
        }
        return result;
    }

    @Exclude
    public boolean isLocked(K key) {
        Entry<K, V> entry = this.getEntry(key, false);
        return entry != null && entry.locked != null;
    }

    @Exclude
    public final int getLockedCount() {
        return this.lockCount;
    }

    @Exclude
    public LockOwner getLocker(K key) {
        Entry<K, V> entry = this.getEntry(key, false);
        return entry == null ? null : entry.locked;
    }

    @Override
    public void clear() {
        this.map.clear();
        for (Entry<K, V> entry : this.elements) {
            if (((Entry)entry).isEmpty()) {
                this.dispose(entry.value);
                entry.value = null;
            }
            entry.clock = 0;
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V> entry;
        boolean result = false;
        Entry<K, V>[] arr$ = this.elements;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(result = (entry = arr$[i$]).equals(value)); ++i$) {
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final ArrayList<Entry<K, V>> result = new ArrayList<Entry<K, V>>(this.size());
        for (Entry<K, V> entry : this.elements) {
            if (!((Entry)entry).isEmpty()) continue;
            result.add(entry);
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return result.iterator();
            }

            @Override
            public int size() {
                return result.size();
            }
        };
    }

    @Override
    public V get(Object k) {
        K key = null;
        Entry<Object, V> entry = this.getEntry(key = Cast.forceTo(key, k), true);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> entry = this.putEntry(key, value);
        return entry == null ? null : (V)entry.value;
    }

    @Exclude
    public V putLocked(K key, V value, LockOwner owner) {
        Entry<K, V> entry = this.putEntry(key, value);
        V result = null;
        if (entry != null) {
            if (entry.locked == null) {
                ++this.lockCount;
            }
            entry.locked = owner;
            result = entry.value;
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = null;
        Entry<K, V> entry = this.map.remove(key);
        if (entry != null) {
            result = entry.value;
            entry.clock = 0;
            entry.key = null;
            entry.value = null;
            if (entry.locked != null) {
                entry.locked = null;
                --this.lockCount;
            }
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("<");
        for (Entry<K, V> entry : this.elements) {
            if (!((Entry)entry).isEmpty()) continue;
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(entry.value);
            if (entry.locked != null) continue;
            result.append("[locking info: ");
            result.append(entry.locked.toString());
            result.append("]");
        }
        return result.append(">").toString();
    }

    public V unlock(K key) {
        V result = null;
        Entry<K, V> entry = this.getEntry(key, false);
        if (entry != null && entry.locked != null) {
            --this.lockCount;
            entry.locked = null;
            result = entry.value;
        } else if (!this.isLocked(key)) {
            Log.logWarning(CoreMsg.UNLOCK_NOT_LOCKED(Thread.currentThread(), key));
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        for (Entry<K, V> entry : this.elements) {
            if (!((Entry)entry).isEmpty()) continue;
            result.add(entry.value);
        }
        return result;
    }

    protected void dispose(V o) {
    }

    protected V load(K key) {
        return null;
    }

    private Entry<K, V> getEntry(K key, boolean load) {
        Entry<K, V> result = this.map.get(key);
        if (result != null) {
            ++result.clock;
        } else {
            V obj = load ? (V)this.load(key) : null;
            result = obj == null ? null : this.putEntry(key, obj);
        }
        return result;
    }

    private Entry<K, V> putEntry(K key, V value) {
        Entry<K, V> result = this.map.get(key);
        if (result == null) {
            for (Entry<K, V> entry : this.elements) {
                if (entry.value != null) continue;
                result = entry;
                break;
            }
            if (result == null) {
                int capacity = this.elements.length;
                if (this.lockCount >= capacity) {
                    throw new NoDisposableEntriesException();
                }
                while (this.elements[this.clock].clock > 0 || this.elements[this.clock].locked != null) {
                    --this.elements[this.clock].clock;
                    ++this.clock;
                    this.clock %= capacity;
                }
                result = this.elements[this.clock];
                this.map.remove(result.key);
                this.dispose(result.value);
            }
        }
        this.map.put(key, result);
        result.key = key;
        result.value = value;
        result.clock = 1;
        return result;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (Entry<K, V> entry : this.elements) {
            if (!((Entry)entry).isEmpty()) continue;
            this.map.put(entry.key, entry);
            if (entry.locked == null) continue;
            ++this.lockCount;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        int clock;
        K key;
        LockOwner locked;
        V value;

        Entry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        private boolean isEmpty() {
            return this.value != null;
        }
    }

    public static class NoDisposableEntriesException
    extends RuntimeException {
        static final long serialVersionUID = 5591293186382490816L;
        static final long serialCheck = -4154112361487813492L;
    }

    public static class AlreadyLockedException
    extends Exception {
        private Object key;
        private LockOwner owner;
        static final long serialVersionUID = -2820907264909285558L;
        static final long serialCheck = -1983224427884733423L;

        public AlreadyLockedException(Object o, LockOwner owner) {
            this.key = o;
            this.owner = owner;
        }

        public Object getEntry() {
            return this.key;
        }

        public LockOwner getOwner() {
            return this.owner;
        }
    }
}

