/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs.java;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFileSystem
extends VFileSystem {
    private final File fileSystemRoot;

    public JavaFileSystem(@NotNull File fileSystemRoot) {
        if (fileSystemRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.<init> must not be null");
        }
        this.fileSystemRoot = JavaFileSystem.normalizeFile(fileSystemRoot);
        if (!fileSystemRoot.isDirectory()) {
            throw new IllegalArgumentException(fileSystemRoot + " is not a directory");
        }
    }

    public File getFileSystemRoot() {
        return this.fileSystemRoot;
    }

    public String getPathSeparator() {
        return File.separator;
    }

    @Override
    public VFile[] list(@NotNull VFile vFile, final @Nullable VFileFilter filter) throws IOException {
        File[] files;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.list must not be null");
        }
        File file = this.toJavaFile(vFile);
        FileFilter fileFilter = filter == null ? null : new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                assert (filter != null);
                try {
                    return filter.accept(JavaFileSystem.this.toVFile(pathname));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            files = file.listFiles(fileFilter);
        }
        catch (RuntimeException e) {
            throw new IOException(e.getCause());
        }
        VFile[] result = new VFile[]{};
        if (files != null) {
            result = new VFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                result[i] = this.toVFile(files[i]);
            }
        }
        return result;
    }

    @Override
    public void flush() {
    }

    public File toJavaFile(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.toJavaFile must not be null");
        }
        assert (vFile.getFileSystem() == this) : "vfile does not belong to this filesystem";
        String child = vFile.getCanonicalPath().replace('/', File.separatorChar);
        File file = new File(this.fileSystemRoot, child);
        return file.getAbsoluteFile();
    }

    @Override
    public long lastModified(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.lastModified must not be null");
        }
        return this.toJavaFile(vFile).lastModified();
    }

    @Override
    public boolean isZeroLength(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.isZeroLength must not be null");
        }
        return this.toJavaFile(vFile).length() <= 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<String> getURIParts(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.getURIParts must not be null");
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.fileSystemRoot.toURI().toString());
        parts.add(vFile.getCanonicalPath());
        ArrayList<String> arrayList = parts;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/java/JavaFileSystem.getURIParts must not return null");
        }
        return arrayList;
    }

    @Override
    protected boolean delete(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.delete must not be null");
        }
        if (this.isRoot(vFile)) {
            throw new IOException("You can't delete the root folder");
        }
        boolean result = this.delete(this.toJavaFile(vFile));
        if (result) {
            this.fireEvent(new VFileEvent(VEventType.REMOVE, vFile));
        }
        return result;
    }

    protected boolean delete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.delete must not be null");
        }
        return file.delete();
    }

    @Override
    protected boolean mkdirs(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.mkdirs must not be null");
        }
        boolean ret = this.toJavaFile(vFile).mkdirs();
        this.fireEvent(new VFileEvent(VEventType.ADD, vFile));
        return ret;
    }

    @Override
    protected boolean exists(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.exists must not be null");
        }
        return this.toJavaFile(vFile).exists();
    }

    @Override
    protected boolean isDirectory(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.isDirectory must not be null");
        }
        return this.toJavaFile(vFile).isDirectory();
    }

    @Override
    protected boolean canWrite(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.canWrite must not be null");
        }
        return this.toJavaFile(vFile).canWrite();
    }

    @Override
    protected InputStream openInputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.openInputStream must not be null");
        }
        return new FileInputStream(this.toJavaFile(vFile));
    }

    @Override
    protected boolean isHidden(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.isHidden must not be null");
        }
        File file = this.toJavaFile(vFile);
        return file.isHidden();
    }

    @Override
    protected OutputStream openOutputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.openOutputStream must not be null");
        }
        File file = this.toJavaFile(vFile);
        if (file.isDirectory()) {
            throw new FileNotFoundException(vFile.getCanonicalPath());
        }
        vFile.setCreated(!file.exists());
        return this.createOutputStream(file);
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    protected VFile toVFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.toVFile must not be null");
        }
        String fileAbsolutePath = JavaFileSystem.normalizeFile(file).getPath();
        return this.toVFile(fileAbsolutePath);
    }

    protected VFile toVFile(@NotNull String fileAbsolutePath) throws IOException {
        if (fileAbsolutePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.toVFile must not be null");
        }
        String rootAbsolutePath = this.fileSystemRoot.getPath();
        if (!fileAbsolutePath.startsWith(rootAbsolutePath)) {
            throw new IOException(fileAbsolutePath + " does not belong to the filesystem rooted at " + this.fileSystemRoot);
        }
        String vFilePath = fileAbsolutePath.substring(rootAbsolutePath.length()).replace(File.separatorChar, '/');
        if (vFilePath.length() == 0) {
            vFilePath = "/";
        } else if (vFilePath.charAt(0) != '/') {
            vFilePath = "/" + vFilePath;
        }
        return this.createFile(vFilePath);
    }

    private static File normalizeFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/java/JavaFileSystem.normalizeFile must not be null");
        }
        File normalized = new File(file.toURI().normalize());
        return normalized.getPath().equals(file.getPath()) ? file : normalized;
    }

    private boolean isRoot(VFile vFile) {
        return this.getRoot().equals(vFile);
    }
}

