/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.bpm.lang.Cast;
import oracle.bpm.log.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamUtils {
    private StreamUtils() {
    }

    public static BufferedInputStream buffered(InputStream is) {
        return is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static char[] readChars(@NotNull Reader is) throws IOException {
        CharArrayWriter out;
        if (is == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/StreamUtils.readChars must not be null");
        }
        try {
            int len;
            out = new CharArrayWriter();
            char[] buff = new char[1024];
            while ((len = is.read(buff)) != -1) {
                out.write(buff, 0, len);
            }
            is.close();
        }
        catch (Throwable throwable) {
            StreamUtils.close(is);
            throw throwable;
        }
        StreamUtils.close(is);
        char[] cArray = out.toCharArray();
        if (cArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/StreamUtils.readChars must not return null");
        }
        return cArray;
    }

    public static long copy(@NotNull InputStream inStream, @NotNull OutputStream outStream) throws IOException {
        int nread;
        if (inStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/StreamUtils.copy must not be null");
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/StreamUtils.copy must not be null");
        }
        int buffSize = 8192;
        byte[] buff = new byte[8192];
        long transferred = 0L;
        IOException exception = null;
        int len = 0;
        do {
            try {
                nread = inStream.read(buff, len, 8192 - len);
            }
            catch (IOException e) {
                exception = e;
                nread = -1;
            }
            if (!(nread == -1 ? len > 0 : (len += nread) > 4096)) continue;
            outStream.write(buff, 0, len);
            transferred += (long)len;
            len = 0;
        } while (nread != -1);
        if (exception != null) {
            throw exception;
        }
        return transferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static byte[] readBytes(@NotNull InputStream is) throws IOException {
        ByteArrayOutputStream out;
        if (is == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/StreamUtils.readBytes must not be null");
        }
        try {
            out = new ByteArrayOutputStream();
            StreamUtils.copy(is, out);
            is.close();
        }
        catch (Throwable throwable) {
            StreamUtils.close(is);
            throw throwable;
        }
        StreamUtils.close(is);
        byte[] byArray = out.toByteArray();
        if (byArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/StreamUtils.readBytes must not return null");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(ZipInputStream jis, File destinationDir) throws IOException {
        try {
            if (destinationDir.isDirectory()) {
                StreamUtils.unzip(jis, destinationDir);
            }
            jis.close();
        }
        catch (Throwable throwable) {
            StreamUtils.close(jis);
            throw throwable;
        }
        StreamUtils.close(jis);
    }

    public static void close(Closeable ... closeable) {
        if (closeable != null) {
            for (Closeable closeableObject : closeable) {
                if (closeableObject == null) continue;
                try {
                    closeableObject.close();
                }
                catch (IOException e) {
                    Log.logTrace(e);
                }
            }
        }
    }

    public static void writeSerializedObject(File file, Object object) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        StreamUtils.writeSerializedObject(fos, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSerializedObject(OutputStream os, Object object) throws IOException {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            oos.close();
        }
        catch (Throwable throwable) {
            StreamUtils.close(os);
            throw throwable;
        }
        StreamUtils.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T readSerializedObject(@NotNull InputStream is, final @Nullable ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Object result;
        if (is == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/StreamUtils.readSerializedObject must not be null");
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            ObjectInputStream ois = new ObjectInputStream(bis){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    return Class.forName(desc.getName(), true, classLoader);
                }
            };
            result = Cast.force(ois.readObject());
            ois.close();
        }
        catch (Throwable throwable) {
            StreamUtils.close(is);
            throw throwable;
        }
        StreamUtils.close(is);
        Object t = result;
        if (t == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/StreamUtils.readSerializedObject must not return null");
        }
        return t;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T readSerializedObject(@NotNull File file, @Nullable ClassLoader classLoader) throws IOException, ClassNotFoundException {
        T t;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/StreamUtils.readSerializedObject must not be null");
        }
        T t2 = t = StreamUtils.readSerializedObject(new FileInputStream(file), classLoader);
        if (t2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/StreamUtils.readSerializedObject must not return null");
        }
        return t2;
    }

    public static OutputStream nullOutputStream() {
        return NullOutputStream.INSTANCE;
    }

    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        FileInputStream in = new FileInputStream(zipFile);
        ZipInputStream zin = new ZipInputStream(in);
        StreamUtils.unzip(zin, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(ZipInputStream zin, File destDir) throws IOException {
        try {
            ZipEntry e;
            while ((e = zin.getNextEntry()) != null) {
                long time;
                File file = new File(destDir, e.getName());
                if (e.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        StreamUtils.copy(zin, out);
                        out.close();
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close(out);
                        throw throwable;
                    }
                    StreamUtils.close(out);
                }
                if ((time = e.getTime()) < 0L) continue;
                file.setLastModified(time);
            }
            zin.close();
        }
        catch (Throwable throwable) {
            StreamUtils.close(zin);
            throw throwable;
        }
        StreamUtils.close(zin);
    }

    private static final class NullWriter
    extends Writer {
        static final Writer INSTANCE = new NullWriter();

        private NullWriter() {
        }

        @Override
        public void write(int c) {
        }

        @Override
        public void write(String str, int off, int len) {
            assert (off >= 0 && len >= 0 && off + len <= str.length());
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            assert (off >= 0 && len >= 0 && off + len <= cbuf.length);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        static final OutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
            assert (off >= 0 && len >= 0 && off + len <= b.length);
        }
    }
}

