/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bpm.collections.Procedure;
import oracle.bpm.component.Replaceable;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NonNls;

public class ReferenceManager {
    private ReferenceCollector collector = new ReferenceCollector();
    private long nextKey = 0L;
    private IndentedPrintWriter pw;
    private final HashMap<Long, Object> references = new HashMap();
    private volatile Procedure<Object>[] visitors;
    private final Object visitorsLock = new Object();
    @NonNls
    private static final String CREATION_STACK_FIELD = "creationStack";
    @NonNls
    private static final String REFERENCE_MANAGER_LOGDIR = "oracle.bpm.io.ReferenceManager.logdir";
    private static final String FUEGO_LANG_INTERVAL = Interval.class.getName();
    private static final String FUEGO_LANG_TIME = Time.class.getName();
    private static final WeakHashMap<Class, SoftReference<Field[]>> accessibleFieldCache = new WeakHashMap();
    protected static final int EMPTY_KEY = 0;
    @NonNls
    private static final String REFERENCE_MANAGER_DEBUG = "oracle.bpm.io.ReferenceManager.debug";
    public static final boolean debug = Boolean.getBoolean("oracle.bpm.io.ReferenceManager.debug");

    public ReferenceManager() {
        if (debug) {
            OutputStream os;
            File file = new File(System.getProperty(REFERENCE_MANAGER_LOGDIR, System.getProperty("java.io.tmpdir")), ReferenceManager.toString(this) + ".log");
            try {
                os = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                os = System.out;
            }
            this.pw = new IndentedPrintWriter(os, true);
        }
    }

    public static long getReferenceId(Replaceable obj) {
        if (obj == null) {
            throw new NullPointerException("object cannot be null");
        }
        Field field = ReferenceManager.getField(obj);
        return ReferenceManager.getFieldValue(field, obj);
    }

    public static void override(Object obj) throws IOException {
        Field field;
        if (obj instanceof Replaceable && (field = ReferenceManager.getField(obj)) != null) {
            field.setAccessible(true);
            long key = ReferenceManager.getFieldValue(field, obj);
            if (key > 0L) {
                ReferenceManager.setFieldValue(field, obj, -key);
            }
        }
    }

    public static void reset(Object obj) throws IOException {
        Field field;
        if (obj instanceof Replaceable && (field = ReferenceManager.getField(obj)) != null) {
            field.setAccessible(true);
            ReferenceManager.setFieldValue(field, obj, 0L);
        }
    }

    public static boolean isDebugEnabled() {
        return debug;
    }

    public void assignUniqueId(Object obj) throws IOException {
        Field field;
        if (obj instanceof Replaceable && (field = ReferenceManager.getField(obj)) != null) {
            field.setAccessible(true);
            ReferenceManager.setFieldValue(field, obj, this.makeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisitor(Procedure<Object> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Object object = this.visitorsLock;
        synchronized (object) {
            if (this.visitors == null) {
                this.visitors = (Procedure[])Cast.force(new Procedure[]{visitor});
            } else {
                int length = this.visitors.length;
                assert (length > 0 && length < 10) : "length > 0 && length < 10";
                if (length == 1) {
                    if (this.visitors[0] != visitor) {
                        this.visitors = (Procedure[])Cast.force(new Procedure[]{this.visitors[0], visitor});
                    }
                } else {
                    Procedure[] newArray = (Procedure[])Cast.force(new Procedure[length + 1]);
                    for (int i = 0; i < this.visitors.length; ++i) {
                        Procedure<Object> candidate = this.visitors[i];
                        if (visitor == candidate) {
                            return;
                        }
                        newArray[i] = candidate;
                    }
                    newArray[length] = visitor;
                    this.visitors = newArray;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisitor(Procedure visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        Object object = this.visitorsLock;
        synchronized (object) {
            if (this.visitors != null) {
                int length = this.visitors.length;
                assert (length > 0 && length <= 10) : "length > 0 && length <= 10";
                if (length == 1) {
                    if (this.visitors[0] == visitor) {
                        this.visitors = null;
                    }
                } else {
                    int index = -1;
                    for (Procedure<Object> visitor1 : this.visitors) {
                        if (visitor1 != visitor) continue;
                        index = 1;
                        break;
                    }
                    if (index != -1) {
                        Procedure[] newArray = (Procedure[])Cast.force(new Procedure[length - 1]);
                        System.arraycopy(this.visitors, 0, newArray, 0, index);
                        System.arraycopy(this.visitors, index + 1, newArray, index, length - index - 1);
                        this.visitors = newArray;
                    }
                }
            }
        }
    }

    public void replace(IdentityHashMap<Object, Object> replacements) {
        if (debug) {
            this.pw.println("replace: processing main replacements");
            this.pw.indent();
        }
        IdentityHashMap<Object, Object> transientReplacements = this.doReplacements(replacements, replacements);
        if (debug) {
            this.pw.dedent();
        }
        while (!transientReplacements.isEmpty()) {
            if (debug) {
                this.pw.println("replace: processing transient replacements");
                this.pw.indent();
            }
            transientReplacements = this.doReplacements(transientReplacements, replacements);
            if (!debug) continue;
            this.pw.dedent();
        }
        if (debug) {
            this.pw.println("replace: done!");
        }
    }

    public Object processRead(IdentityHashMap<Object, Object> replacements, Object obj) throws IOException {
        if (debug) {
            this.pw.println("processRead: " + ReferenceManager.toString(obj));
            this.pw.indent();
        }
        Object replacement = null;
        if (obj != null) {
            replacement = replacements.containsKey(obj) ? replacements.get(obj) : this.addReplacement(obj, replacements);
        }
        if (debug) {
            this.pw.println("replacing: " + ReferenceManager.toString(obj) + " by " + ReferenceManager.toString(replacement));
            this.pw.dedent();
        }
        return replacement;
    }

    public void processWrite(Object obj) throws IOException {
        Field field;
        if (debug) {
            this.pw.println("processWrite: writting " + ReferenceManager.toString(obj));
            this.pw.indent();
        }
        if (obj instanceof Replaceable && (field = ReferenceManager.getField(obj)) != null) {
            field.setAccessible(true);
            long key = ReferenceManager.getFieldValue(field, obj);
            if (key == 0L) {
                this.allocate(obj, field);
            } else if (key < 0L) {
                this.override(-key, obj);
                ReferenceManager.setFieldValue(field, obj, -key);
            } else {
                Object found = this.find(key);
                if (found == null) {
                    this.add(key, obj);
                } else if (debug && found != obj) {
                    this.pw.println(this.duplicateAssertion(key, obj));
                }
            }
        }
        if (debug) {
            this.pw.dedent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long makeId() {
        long key;
        ReferenceManager referenceManager = this;
        synchronized (referenceManager) {
            key = ++this.nextKey;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object find(long key) {
        HashMap<Long, Object> hashMap = this.references;
        synchronized (hashMap) {
            ObjectRef ref = (ObjectRef)this.references.get(key);
            Object obj = null;
            if (ref != null) {
                obj = ref.get();
            }
            if (obj == null) {
                this.references.remove(key);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field[] getAllFields(Class klass) {
        Field[] fields = null;
        WeakHashMap<Class, SoftReference<Field[]>> weakHashMap = accessibleFieldCache;
        synchronized (weakHashMap) {
            SoftReference<Field[]> ref = accessibleFieldCache.get(klass);
            if (ref != null) {
                fields = ref.get();
            }
            if (fields == null) {
                fields = JavaClass.getAllFields(klass);
                accessibleFieldCache.put(klass, new SoftReference<Field[]>(fields));
            }
        }
        return fields;
    }

    private static Field getField(Object obj) {
        Field field;
        try {
            field = obj.getClass().getDeclaredField("__replacementId");
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        if (field != null && field.getType() != Long.TYPE) {
            field = null;
        }
        return field;
    }

    private static void setFieldValue(Field field, Object obj, long value) throws IOException {
        try {
            field.setLong(obj, value);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException("Unable to access field: " + field.getName()).initCause(e);
        }
    }

    private static long getFieldValue(Field field, Object obj) {
        long value;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            value = field.getLong(obj);
        }
        catch (IllegalAccessException e) {
            assert (false) : "unexpected exception: " + e.getMessage();
            value = 0L;
        }
        return value;
    }

    private static boolean equals(Object newVal, Object oldVal) {
        if (newVal == null) {
            return oldVal == null;
        }
        return oldVal != null && oldVal == newVal;
    }

    private static String toString(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private String getCreation(Object o) {
        String stack;
        try {
            Class<?> aClass = o.getClass();
            Field declaredField = aClass.getDeclaredField(CREATION_STACK_FIELD);
            declaredField.setAccessible(true);
            stack = String.valueOf(declaredField.get(o));
        }
        catch (Exception e) {
            stack = "<not found : " + e.getMessage() + ">";
        }
        return stack;
    }

    private long allocate(Object obj, Field field) throws IOException {
        assert (obj != null) : "obj cannot be null";
        long key = this.makeId();
        assert (key != 0L) : "key must be different than EMPTY_KEY: " + key;
        assert (this.find(key) == null) : "key already used, keys must be unique: " + key;
        this.add(key, obj);
        ReferenceManager.setFieldValue(field, obj, key);
        return key;
    }

    private IdentityHashMap<Object, Object> doReplacements(IdentityHashMap<Object, Object> target, IdentityHashMap<Object, Object> replacements) {
        if (debug) {
            this.pw.println("doReplacements: begin");
            this.pw.indent();
        }
        IdentityHashMap<Object, Object> transientReplacements = new IdentityHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : target.entrySet()) {
            Object original = entry.getKey();
            Object changed = entry.getValue();
            assert (original != null) : "original cannot be null";
            this.replace(changed, original, replacements, transientReplacements);
            this.visit(changed);
        }
        if (debug) {
            this.pw.dedent();
            this.pw.println("doReplacements: end");
        }
        return transientReplacements;
    }

    private String duplicateAssertion(long key, Object obj) {
        ClassLoader foundCl;
        ClassLoader objectCl;
        Object found = this.find(key);
        String message = "key should be mapped or duplicate mapping found: key=" + key + ", obj=" + obj + ", mapped=" + found + ", this=" + this;
        if (debug) {
            this.pw.println("duplicateAssertion: obj=" + ReferenceManager.toString(obj));
            this.pw.indent();
            this.pw.println(this.getCreation(obj));
            this.pw.dedent();
            this.pw.println("duplicateAssertion: found=" + ReferenceManager.toString(found));
            this.pw.indent();
            this.pw.println(this.getCreation(found));
            this.pw.dedent();
        }
        if (obj != null && found != null && (objectCl = obj.getClass().getClassLoader()) != (foundCl = found.getClass().getClassLoader())) {
            message = message + "\nClassLoaders are different: objCl=" + objectCl + ", foundCl= " + foundCl;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(long key, Object obj) {
        if (debug) {
            this.pw.println("add: key=" + key + ", obj=" + ReferenceManager.toString(obj));
        }
        HashMap<Long, Object> hashMap = this.references;
        synchronized (hashMap) {
            this.references.put(key, new ObjectRef(key, obj, this.collector));
        }
    }

    private Object addReplacement(Object obj, IdentityHashMap<Object, Object> replacements) {
        long key;
        Field field;
        assert (obj != null) : "obj cannot be null";
        Object replacement = null;
        if (obj instanceof Replaceable && (field = ReferenceManager.getField(obj)) != null && (key = ReferenceManager.getFieldValue(field, obj)) != 0L && (replacement = this.find(key)) == null) {
            this.add(key, obj);
        }
        if (replacement == null) {
            replacement = obj;
        }
        assert (obj.getClass() == replacement.getClass()) : "Classes do not match: " + obj.getClass() + ", " + replacement.getClass();
        replacements.put(obj, replacement);
        return replacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void override(long key, Object obj) {
        if (debug) {
            this.pw.println("override: key=" + key + ", obj=" + ReferenceManager.toString(obj));
        }
        HashMap<Long, Object> hashMap = this.references;
        synchronized (hashMap) {
            ObjectRef ref = (ObjectRef)this.references.get(key);
            if (ref != null) {
                ObjectRef objectRef = ref;
                synchronized (objectRef) {
                    ref.setKey(0L);
                }
            }
            this.references.put(key, new ObjectRef(key, obj, this.collector));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(ObjectRef ref) {
        HashMap<Long, Object> hashMap = this.references;
        synchronized (hashMap) {
            long key;
            ObjectRef objectRef = ref;
            synchronized (objectRef) {
                key = ref.getKey();
            }
            if (key != 0L) {
                this.references.remove(key);
            }
        }
    }

    private void replace(Object target, Object source, IdentityHashMap<Object, Object> replacements, IdentityHashMap<Object, Object> transientReplacements) {
        boolean isArray;
        Class<?> klass = target.getClass();
        Class<?> componentType = klass.getComponentType();
        if (debug) {
            this.pw.println("replace: copying fields from " + ReferenceManager.toString(source) + " into " + ReferenceManager.toString(target));
            this.pw.indent();
        }
        if (!(isArray = klass.isArray()) && this.shouldProcess(klass)) {
            Field[] fields = ReferenceManager.getAllFields(klass);
            try {
                for (Field field : fields) {
                    int modifiers = field.getModifiers();
                    if (!Modifier.isFinal(modifiers)) {
                        Object srcVal;
                        if (debug) {
                            this.pw.println("processing field: " + field);
                            this.pw.indent();
                        }
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        Object oldVal = field.get(target);
                        if (source == null) {
                            if (debug) {
                                this.pw.println("source is null, target: " + target);
                            }
                            srcVal = oldVal;
                        } else {
                            try {
                                srcVal = field.get(source);
                            }
                            catch (IllegalArgumentException e) {
                                if (debug) {
                                    this.pw.println("**************************************");
                                    this.pw.println("Field: " + field);
                                    this.pw.println("Source: " + source);
                                    this.pw.println("Field ClassLoader: " + field.getDeclaringClass().getClassLoader());
                                    this.pw.println("Source ClassLoader: " + source.getClass().getClassLoader());
                                    this.pw.println("**************************************");
                                    this.pw.dedent();
                                }
                                throw e;
                            }
                        }
                        Object newVal = srcVal;
                        if (replacements.containsKey(newVal)) {
                            newVal = replacements.get(newVal);
                        }
                        if (!ReferenceManager.equals(oldVal, newVal)) {
                            if (debug) {
                                this.pw.println("changing " + ReferenceManager.toString(oldVal) + " to " + ReferenceManager.toString(newVal));
                            }
                            if (Modifier.isTransient(modifiers) && newVal != null && !replacements.containsKey(newVal)) {
                                if (debug) {
                                    this.pw.println("adding transient replacement for " + ReferenceManager.toString(newVal));
                                }
                                transientReplacements.put(newVal, newVal);
                            }
                            field.set(target, newVal);
                        }
                        if (!debug) continue;
                        this.pw.dedent();
                        continue;
                    }
                    if (!debug) continue;
                    this.pw.println("skipping field: " + field);
                }
            }
            catch (IllegalAccessException e) {
                assert (false) : "unexpected exception";
            }
        } else if (isArray && !componentType.isPrimitive() && !componentType.isArray()) {
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object oldVal;
                Object newVal = oldVal = Array.get(target, i);
                if (replacements.containsKey(oldVal)) {
                    newVal = replacements.get(oldVal);
                }
                if (ReferenceManager.equals(oldVal, newVal)) continue;
                Array.set(target, i, newVal);
            }
        }
        if (debug) {
            this.pw.dedent();
        }
    }

    private boolean shouldProcess(Class klass) {
        String name = klass.getName();
        return !name.startsWith("java.lang") && !name.startsWith("java.math") && !name.equals(FUEGO_LANG_INTERVAL) && !name.equals(FUEGO_LANG_TIME);
    }

    private void visit(Object obj) {
        Procedure<Object>[] visitors = this.visitors;
        if (visitors != null) {
            for (Procedure<Object> visitor : visitors) {
                if (visitor.execute(obj)) continue;
                this.removeVisitor(visitor);
            }
        }
    }

    private class ReferenceCollector
    extends ReferenceQueue<Object>
    implements LowResolutionTimerListener {
        private LowResolutionTimer timer = new LowResolutionTimer(60);

        public ReferenceCollector() {
            this.timer.add(this);
            this.timer.start();
        }

        @Override
        public void timerFired(LowResolutionTimer timer) {
            Reference ref = this.poll();
            while (ref != null) {
                ReferenceManager.this.release((ObjectRef)ref);
                ref = this.poll();
            }
        }
    }

    private static class ObjectRef
    extends WeakReference<Object> {
        long key;

        public ObjectRef(long key, Object referent, ReferenceQueue<Object> q) {
            super(referent, q);
            this.key = key;
        }

        public void setKey(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }
    }
}

