/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.Writer;

public class IndentedWriter
extends Writer {
    private int indent;
    private boolean onNewLine = true;
    private final Writer out;

    public IndentedWriter(Writer out) {
        assert (out != null) : "out is null";
        this.out = out;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        char c = '\u0000';
        for (int i = 0; i < len; ++i) {
            if (this.onNewLine) {
                this.writeIndent();
                this.onNewLine = false;
            }
            c = cbuf[i + off];
            this.out.write(c);
            if (c != '\n') continue;
            this.onNewLine = true;
        }
    }

    public void indent() {
        ++this.indent;
    }

    public void dedent() {
        --this.indent;
        assert (this.indent >= 0) : "too many dedents";
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void writeIndent() throws IOException {
        for (int j = 0; j < this.indent; ++j) {
            this.out.write(9);
        }
    }
}

