/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import oracle.bpm.io.PersistenceInputStream;
import oracle.bpm.log.Log;

public class ClassLoaderObjectInputStream
extends PersistenceInputStream {
    private ClassLoader classLoader;

    public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            Log.logSevere(e);
            throw e;
        }
    }
}

