/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class Dimension
implements Serializable {
    private final int height;
    private final int width;
    private static final int ZERO_CONSTANT = 0;
    public static final Dimension ZERO = Dimension.valueOf(0, 0);
    public static Dimension MAX_VALUE = Dimension.valueOf(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final long serialVersionUID = 4723952579491349524L;
    static final long serialCheck = -140484804232783864L;

    public Dimension() {
        this(0, 0);
    }

    public Dimension(Dimension d) {
        this(d.getWidth(), d.getHeight());
    }

    private Dimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static Dimension max(Dimension d1, Dimension d2) {
        int width = Math.max(d1.getWidth(), d2.getWidth());
        int height = Math.max(d1.getHeight(), d2.getHeight());
        return new Dimension(width, height);
    }

    public static Dimension valueOf(int width, int height) {
        return new Dimension(width, height);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Dimension sub(@NotNull Dimension that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Dimension.sub must not be null");
        }
        return Dimension.valueOf(this.getWidth() - that.getWidth(), this.getHeight() - that.getHeight());
    }

    public Dimension add(@NotNull Dimension that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Dimension.add must not be null");
        }
        return Dimension.valueOf(this.getWidth() + that.getWidth(), this.getHeight() + that.getHeight());
    }

    public Dimension div(int divisor) {
        return Dimension.valueOf(this.getWidth() / divisor, this.getHeight() / divisor);
    }

    public Dimension mul(int times) {
        return Dimension.valueOf(this.getWidth() * times, this.getHeight() * times);
    }

    public int sqValue() {
        return this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Dimension)) {
            return false;
        }
        Dimension dim = (Dimension)obj;
        return this.getWidth() == dim.getWidth() && this.getHeight() == dim.getHeight();
    }

    public int hashCode() {
        return 29 * this.getWidth() + this.getHeight();
    }

    public Dimension scale(float prop) {
        return new Dimension(Math.round((float)this.getWidth() * prop), Math.round((float)this.getHeight() * prop));
    }

    public String toString() {
        return "[width: " + this.getWidth() + ", height: " + this.getHeight() + "]";
    }

    public Dimension xProjection() {
        return Dimension.valueOf(0, this.getHeight());
    }

    public Dimension yProjection() {
        return Dimension.valueOf(this.getWidth(), 0);
    }

    public Dimension transposed() {
        return Dimension.valueOf(this.height, this.width);
    }

    public Dimension add(int w, int h) {
        return Dimension.valueOf(this.width + w, this.height + h);
    }
}

