/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.extension;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.extension.AbstractExtension;
import oracle.bpm.extension.DefaultExtensionService;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.log.Log;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionLoader {
    private URL currentUrl;
    private final DefaultHandler saxHandler;

    ExtensionLoader(DefaultExtensionService service) {
        this.saxHandler = this.buildHandler(service);
    }

    protected void loadPlugins() throws IOException {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Enumeration<URL> pluginFiles = classLoader.getResources("bpm-extensions.xml");
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            while (pluginFiles.hasMoreElements()) {
                this.loadPlugin(pluginFiles.nextElement(), parser);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPlugin(URL pluginUrl, SAXParser parser) throws IOException, SAXException {
        InputStream stream = pluginUrl.openStream();
        try {
            this.currentUrl = pluginUrl;
            parser.parse(stream, this.saxHandler);
            stream.close();
            this.currentUrl = null;
        }
        catch (Throwable throwable) {
            this.currentUrl = null;
            StreamUtils.close(stream);
            throw throwable;
        }
        StreamUtils.close(stream);
    }

    private DefaultHandler buildHandler(final DefaultExtensionService service) {
        return new DefaultHandler(){
            String id;
            String point;

            @Nullable
            private String getRequired(Attributes attributes, String qName) {
                String value = attributes.getValue(qName);
                if (value == null) {
                    Log.logDebug("Missing extension attribute \"" + qName + "\" in " + ExtensionLoader.this.currentUrl);
                }
                return value;
            }

            @Override
            public void startDocument() {
                this.id = null;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                String pointValue;
                if (this.id != null) {
                    String id = this.id;
                    this.id = null;
                    int length = attributes.getLength();
                    Map<String, String> properties = CollectionUtils.hashMap(length);
                    for (int i = 0; i < length; ++i) {
                        properties.put(attributes.getQName(i).intern(), attributes.getValue(i).intern());
                    }
                    DynamicExtensionImpl extension = new DynamicExtensionImpl(id, properties);
                    service.addExtensionTo(extension, this.point);
                } else if ("extension".equals(qName) && (pointValue = this.getRequired(attributes, "point")) != null) {
                    this.point = pointValue;
                    this.id = this.getRequired(attributes, "id");
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.id = null;
            }
        };
    }

    private static class DynamicExtensionImpl
    extends AbstractExtension<Map> {
        DynamicExtensionImpl(String id, Map properties) {
            super(Map.class, id, DynamicExtensionImpl.buildDisplayName(id, properties));
            this.setMetadata(properties);
        }

        @Override
        public Object instantiate() throws InstantiationException {
            return DefaultExtensionService.newInstance(this.instanceType());
        }

        @Override
        public Class instanceType() throws InstantiationException {
            try {
                String className = (String)((Map)this.getMetadata()).get("className");
                return Class.forName(className, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException(e.toString());
            }
        }

        @Override
        protected InvocationHandler createHandler() {
            return null;
        }

        private static String buildDisplayName(String id, Map properties) {
            String result = (String)properties.get("className");
            return result == null ? id : result.substring(result.lastIndexOf(46) + 1);
        }
    }
}

