/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.extension;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.extension.AbstractExtension;
import oracle.bpm.extension.AbstractExtensionService;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionLoader;
import oracle.bpm.log.Log;

public class DefaultExtensionService
extends AbstractExtensionService {
    private final Map<String, Point> pointsById = new HashMap<String, Point>();

    public DefaultExtensionService() {
        this.loadPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromUrl(URL url, Map<String, String> points) throws IOException {
        InputStream resource = url.openStream();
        try {
            DefaultExtensionService.loadFromStream(resource, points);
        }
        finally {
            resource.close();
        }
    }

    public static void loadFromStream(InputStream resource, Map<String, String> points) throws IOException {
        Properties properties = new Properties();
        properties.load(resource);
        for (String name : properties.stringPropertyNames()) {
            if (!name.startsWith("extension.")) continue;
            String className = name.substring("extension.".length());
            String id = properties.getProperty(name);
            assert (className.startsWith("oracle.bpm.extensionpoint.metadata.") || className.startsWith("fuego.extensionpoint.metadata.") || Log.logDebug("Extension point metadata class in unexpected package : " + className));
            points.put(className.intern(), id.intern());
        }
    }

    public <M extends Annotation> List<Extension<M>> getExtensionsByPoint(Class<M> pointType) {
        String pointId = this.getPointId(pointType);
        Point point = this.pointsById.get(pointId);
        List<Extension<M>> result = point != null ? point.getExtensionsAs(pointType) : Collections.emptyList();
        return result;
    }

    @Override
    protected Map<String, String> loadExtensionPoints() throws IOException {
        HashMap<String, String> points = new HashMap<String, String>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> resources = classLoader.getResources("plugin.properties");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            DefaultExtensionService.loadFromUrl(url, points);
        }
        return points;
    }

    static Object newInstance(Class<?> cl) throws InstantiationException {
        try {
            return cl.newInstance();
        }
        catch (Exception cause) {
            InstantiationException exception = new InstantiationException(cause.toString());
            exception.initCause(cause);
            throw exception;
        }
    }

    void addExtensionTo(Extension<Map> extension, String pointId) {
        Point point = this.pointsById.get(pointId);
        if (point == null) {
            point = new Point();
            this.pointsById.put(pointId, point);
        }
        point.addExtension(extension);
    }

    private void loadPlugins() {
        ExtensionLoader loader = new ExtensionLoader(this);
        try {
            loader.loadPlugins();
        }
        catch (IOException e) {
            Log.logSevere(e);
        }
    }

    private static class Point {
        private final List<Extension<Map>> extensions = new ArrayList<Extension<Map>>();

        private Point() {
        }

        void addExtension(Extension<Map> extension) {
            this.extensions.add(extension);
        }

        <T> List<Extension<T>> getExtensionsAs(Class<T> pointType) {
            List<Extension<Map>> extensions = this.extensions;
            ArrayList<Extension<T>> result = new ArrayList<Extension<T>>(extensions.size());
            for (Extension<Map> extension : extensions) {
                result.add(new ExtensionImpl<T>(pointType, extension));
            }
            return result;
        }
    }

    private static class ExtensionImpl<M>
    extends AbstractExtension<M> {
        private Map properties;

        ExtensionImpl(Class<M> pointType, Extension<Map> dynamicExtension) {
            super(pointType, dynamicExtension.getId(), dynamicExtension.getDisplayName());
            this.properties = dynamicExtension.getMetadata();
        }

        @Override
        public Object instantiate() throws InstantiationException {
            return DefaultExtensionService.newInstance(this.instanceType());
        }

        @Override
        public Class instanceType() throws InstantiationException {
            try {
                String className = (String)this.properties.get("className");
                assert (className != null) : "Missing className property in extension definition '" + this.getId() + "'. Defined properties are: " + this.properties;
                return Class.forName(className, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException(e.toString());
            }
        }

        @Override
        protected InvocationHandler createHandler() {
            return new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String name = method.getName();
                    Object value = ExtensionImpl.this.properties.get(name);
                    Class<?> returnType = method.getReturnType();
                    return AbstractExtension.convertTo(value, returnType, ExtensionImpl.this.pointType.getClassLoader());
                }
            };
        }
    }
}

