/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.execution.debug;

import oracle.bpm.execution.Executable;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.execution.InterceptorChain;
import oracle.bpm.lang.Int;
import org.jetbrains.annotations.NonNls;

public class DebugInterceptor
implements Interceptor {
    private ThreadLocal<Int.Holder> nestedLevel = new ThreadLocal<Int.Holder>(){

        @Override
        protected Int.Holder initialValue() {
            return new Int.Holder(0L);
        }
    };

    @Override
    public Object execute(Executable executable, InterceptorChain chain) {
        String className = executable.getClass().getSimpleName();
        Int.Holder level = this.nestedLevel.get();
        long start = System.currentTimeMillis();
        try {
            this.log(level.value, "executing " + className + " with chain: " + chain);
            ++level.value;
            Object object = chain.proceed(executable);
            return object;
        }
        catch (RuntimeException e) {
            this.log(level.value, "failed execution of " + className + " with exception: " + e);
            throw e;
        }
        finally {
            --level.value;
            long elapsedTime = System.currentTimeMillis() - start;
            this.log(level.value, "executed  " + className + " (" + elapsedTime + " milliseconds)");
        }
    }

    private void log(long level, @NonNls String message) {
        int i = 0;
        while ((long)i < level) {
            System.out.print('\t');
            ++i;
        }
        System.out.println(message);
    }
}

