/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.sets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private transient IdentityHashMap<E, Object> map;
    static final long serialVersionUID = -5024744406713321676L;

    public IdentityHashSet() {
        this.init();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, this) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public IdentityHashSet<E> clone() {
        IdentityHashSet newSet;
        try {
            newSet = (IdentityHashSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        newSet.map = (IdentityHashMap)this.map.clone();
        return newSet;
    }

    private void init() {
        this.map = new IdentityHashMap();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        for (E e : this) {
            s.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(s.readObject());
        }
    }
}

