/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.maps;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.collections.comparators.LocaleComparator;
import oracle.bpm.resources.I18nProvider;
import org.jetbrains.annotations.NotNull;

public class LocaleStringMap
extends AbstractMap<Locale, String>
implements Map<Locale, String>,
Cloneable,
Serializable,
I18nProvider,
Iterable<Map.Entry<Locale, String>> {
    protected SortedMap<Locale, String> messageMap = new TreeMap<Locale, String>(LocaleComparator.INSTANCE);
    static final long serialVersionUID = -6425571936302739465L;
    static final long serialCheck = -5822404033643622294L;
    static Locale defaultLocale;

    protected LocaleStringMap() {
    }

    public static LocaleStringMap create() {
        return new LocaleStringMap();
    }

    public static Locale getDefaultLanguage() {
        if (defaultLocale == null || !defaultLocale.equals(Locale.getDefault())) {
            defaultLocale = new Locale(Locale.getDefault().getLanguage());
        }
        return defaultLocale;
    }

    @Override
    public void clear() {
        this.messageMap.clear();
    }

    public void setString(String label) {
        this.put(LocaleStringMap.getDefaultLanguage(), label);
    }

    @Override
    public Set<Map.Entry<Locale, String>> entrySet() {
        return this.messageMap.entrySet();
    }

    @Override
    public Set<Locale> keySet() {
        return this.messageMap.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.messageMap.values();
    }

    @Override
    public String getString() {
        String string = this.getString(LocaleStringMap.getDefaultLanguage());
        if ("".equals(string) && this.messageMap.size() > 0) {
            string = this.getString(this.messageMap.firstKey());
        }
        return string;
    }

    @Override
    public LocaleStringMap clone() {
        LocaleStringMap newL;
        try {
            newL = (LocaleStringMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        newL.messageMap = new TreeMap<Locale, String>(LocaleComparator.INSTANCE);
        for (Locale locale : this.messageMap.keySet()) {
            newL.messageMap.put(locale, (String)this.messageMap.get(locale));
        }
        return newL;
    }

    @Override
    public String toString() {
        return this.getString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public final String getString(@NotNull Locale loc) {
        if (loc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/maps/LocaleStringMap.getString must not be null");
        }
        String result = this.get(loc);
        if (result == null && loc.getVariant().length() != 0) {
            loc = new Locale(loc.getLanguage(), loc.getCountry());
            result = this.get(loc);
        }
        if (result == null && loc.getCountry().length() != 0) {
            loc = new Locale(loc.getLanguage());
            result = this.get(loc);
        }
        if (result == null) {
            return "";
        }
        String string = result;
        if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/maps/LocaleStringMap.getString must not return null");
        return string;
    }

    @Override
    public String put(Locale locale, String text) {
        return this.messageMap.put(locale, text);
    }

    public String remove(Locale locale) {
        return (String)this.messageMap.remove(locale);
    }

    @Override
    public boolean isEmpty() {
        return this.messageMap.isEmpty();
    }

    @Override
    public int size() {
        return this.messageMap.size();
    }

    public boolean containsKey(Locale language) {
        return this.messageMap.containsKey(language);
    }

    public void putAll(LocaleStringMap label) {
        this.messageMap.putAll(label.messageMap);
    }

    @Override
    public Iterator<Map.Entry<Locale, String>> iterator() {
        return this.entrySet().iterator();
    }

    protected String get(Locale locale) {
        return (String)this.messageMap.get(locale);
    }
}

