/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import oracle.bpm.collections.lists.DelegatedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectList
extends DelegatedList<Object>
implements RandomAccess {
    public static ObjectList EMPTY = new ObjectList(Collections.EMPTY_LIST);
    static final long serialVersionUID = -3732050841338072886L;
    static final long serialCheck = 5735509268029427913L;

    private ObjectList(List<Object> list) {
        super(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectList create() {
        ObjectList objectList = ObjectList.create(10);
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.create must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectList create(int initialCapacity) {
        ObjectList objectList = new ObjectList((List<Object>)new ArrayList<Object>(initialCapacity));
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.create must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectList create(Object ... values) {
        ObjectList result;
        if (values == null) {
            result = ObjectList.create();
        } else {
            result = ObjectList.create(values.length);
            result.addAll(values);
        }
        ObjectList objectList = result;
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.create must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectList valueOf(Object ... values) {
        ObjectList objectList = values == null ? EMPTY : new ObjectList(Arrays.asList(values));
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.valueOf must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectList create(@Nullable Collection<Object> values) {
        ObjectList result;
        if (values == null) {
            result = ObjectList.create();
        } else {
            result = ObjectList.create(values.size());
            result.addAll(values);
        }
        ObjectList objectList = result;
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.create must not return null");
        }
        return objectList;
    }

    public static ObjectList singleton(Object element) {
        return new ObjectList(Collections.singletonList(element));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectList subList(int fromIndex, int toIndex) {
        ObjectList objectList = new ObjectList(this.list.subList(fromIndex, toIndex));
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.subList must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectList clone() {
        ObjectList objectList = ObjectList.create(this);
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.clone must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ObjectList add(Object ... values) {
        super.addAll(values);
        ObjectList objectList = this;
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.add must not return null");
        }
        return objectList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ObjectList asUnmodifiable() {
        ObjectList objectList = new ObjectList(Collections.unmodifiableList(this.list));
        if (objectList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ObjectList.asUnmodifiable must not return null");
        }
        return objectList;
    }
}

