/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import oracle.bpm.collections.lists.ComparableList;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsgList
extends ComparableList<Msg>
implements RandomAccess,
Serializable {
    public static MsgList EMPTY = new MsgList(Collections.EMPTY_LIST);
    static final long serialVersionUID = -8049878986030762491L;
    static final long serialCheck = -1902980005113260015L;

    private MsgList(@NotNull List<Msg> delegated) {
        if (delegated == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/MsgList.<init> must not be null");
        }
        super(delegated);
    }

    public static MsgList create() {
        return MsgList.create(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MsgList create(int initialCapacity) {
        MsgList msgList = new MsgList((List<Msg>)new ArrayList<Msg>(initialCapacity));
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.create must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MsgList create(Msg ... values) {
        MsgList result;
        if (values == null) {
            result = MsgList.create();
        } else {
            result = MsgList.create(values.length);
            result.addAll(values);
        }
        MsgList msgList = result;
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.create must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MsgList valueOf(Msg ... values) {
        MsgList msgList = values == null ? EMPTY : new MsgList(Arrays.asList(values));
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.valueOf must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MsgList create(@Nullable Collection<Msg> values) {
        MsgList result;
        if (values == null) {
            result = MsgList.create();
        } else {
            result = MsgList.create(values.size());
            result.addAll(values);
        }
        MsgList msgList = result;
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.create must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MsgList singleton(@NotNull Msg element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/MsgList.singleton must not be null");
        }
        MsgList msgList = new MsgList(Collections.singletonList(element));
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.singleton must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MsgList add(Msg ... values) {
        super.addAll(values);
        MsgList msgList = this;
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.add must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Msg[] toArray() {
        Msg[] msgArray = this.toArray(new Msg[this.size()]);
        if (msgArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.toArray must not return null");
        }
        return msgArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public MsgList subList(int fromIndex, int toIndex) {
        MsgList msgList = new MsgList(this.list.subList(fromIndex, toIndex));
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.subList must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public MsgList clone() {
        MsgList msgList = MsgList.create(this);
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.clone must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MsgList sort() {
        super.sort();
        MsgList msgList = this;
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.sort must not return null");
        }
        return msgList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MsgList asUnmodifiable() {
        MsgList msgList = new MsgList(Collections.unmodifiableList(this.list));
        if (msgList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/MsgList.asUnmodifiable must not return null");
        }
        return msgList;
    }
}

