/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.lists;

import java.util.Collections;
import java.util.List;
import oracle.bpm.collections.lists.DelegatedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComparableList<E extends Comparable<E>>
extends DelegatedList<E> {
    protected ComparableList(@NotNull List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/ComparableList.<init> must not be null");
        }
        super(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ComparableList<E> sort() {
        Collections.sort(this);
        ComparableList comparableList = this;
        if (comparableList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/lists/ComparableList.sort must not return null");
        }
        return comparableList;
    }

    public int binarySearch(@NotNull E key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/lists/ComparableList.binarySearch must not be null");
        }
        return Collections.binarySearch(this, key);
    }

    @Nullable
    public E max() {
        return (E)(this.list.isEmpty() ? null : (Comparable)Collections.max(this.list));
    }

    @Nullable
    public E min() {
        return (E)(this.list.isEmpty() ? null : (Comparable)Collections.min(this.list));
    }
}

