/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.iterator.NoRemoveIterator;

public class FilterIterator<T>
extends NoRemoveIterator<T> {
    private Predicate<? super T> condition;
    private boolean hasNext;
    private Iterator<T> iter;
    private T next;

    public FilterIterator(Iterator<T> iter, Predicate<? super T> condition) {
        this.iter = iter;
        this.condition = condition;
        this.hasNext = true;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.advance();
        return result;
    }

    private void advance() {
        while (this.iter.hasNext()) {
            this.next = this.iter.next();
            if (!this.condition.check(this.next)) continue;
            return;
        }
        this.hasNext = false;
    }
}

