/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.collections.PriorityQueue;

public class TreePriorityQueue<T>
extends AbstractCollection<T>
implements PriorityQueue<T> {
    private Comparator<? super T> comparator;
    private TreeSet<Entry<T>> tree;

    protected TreePriorityQueue(Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.tree = new TreeSet<T>(new EntryComparator<T>(comparator));
    }

    public static <T> TreePriorityQueue<T> create() {
        return new TreePriorityQueue(new NaturalComparator());
    }

    public static <T> TreePriorityQueue<T> create(Comparator<? super T> comparator) {
        return new TreePriorityQueue<T>(comparator);
    }

    @Override
    public boolean add(T o) {
        return this.offer(o);
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public boolean contains(Object o) {
        Object element = o;
        for (Entry entry : this.createSubSet(element)) {
            if (!o.equals(entry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T element() throws NoSuchElementException {
        return this.tree.last().element;
    }

    @Override
    public Iterator<T> iterator() {
        return new EntryIterator<T>(this.tree.iterator());
    }

    @Override
    public boolean offer(T element) {
        Entry<T> entry = Entry.create(element);
        Iterator iterator = this.tree.tailSet(entry).iterator();
        if (!iterator.hasNext()) {
            entry.order = Integer.MAX_VALUE;
        } else {
            Entry first = (Entry)iterator.next();
            entry.order = this.comparator.compare(first.element, element) != 0 ? Integer.MAX_VALUE : first.order - 1;
        }
        return this.tree.add(entry);
    }

    @Override
    public T peek() {
        return this.tree.isEmpty() ? null : (T)this.tree.last().element;
    }

    @Override
    public T poll() {
        return this.isEmpty() ? null : (T)this.remove();
    }

    @Override
    public T remove() throws NoSuchElementException {
        Entry<T> entry = this.tree.first();
        this.tree.remove(entry);
        return entry.element;
    }

    @Override
    public boolean remove(Object o) {
        Object element = o;
        Iterator iterator = this.createSubSet(element).iterator();
        while (iterator.hasNext()) {
            if (!o.equals(iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    private SortedSet<Entry<T>> createSubSet(T element) {
        Entry<T> entry0 = Entry.create(element);
        Entry<T> entryMax = Entry.createMax(element);
        return this.tree.subSet(entry0, entryMax);
    }

    private static class NaturalComparator<T>
    implements Comparator<T> {
        private NaturalComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private static class EntryIterator<T>
    implements Iterator<T> {
        private final Iterator<Entry<T>> iterator;

        public EntryIterator(Iterator<Entry<T>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next().element;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class EntryComparator<T>
    implements Comparator<Entry<T>> {
        private Comparator<? super T> comparator;

        EntryComparator(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Entry<T> o1, Entry<T> o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int result = this.comparator.compare(o1.element, o2.element);
            return result != 0 ? result : o1.order - o2.order;
        }
    }

    private static class Entry<T> {
        T element;
        int order;

        private Entry() {
        }

        public static <T> Entry<T> create(T obj) {
            Entry<T> result = new Entry<T>();
            result.element = obj;
            result.order = 0;
            return result;
        }

        public static <T> Entry<T> createMax(T obj) {
            Entry<T> result = new Entry<T>();
            result.element = obj;
            result.order = Integer.MAX_VALUE;
            return result;
        }
    }
}

