/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.iterator.NoRemoveIterator;
import org.jetbrains.annotations.NotNull;

public class SequenceBuilder<T> {
    @NotNull
    private final List<Iterable<? extends T>> iterables = new ArrayList<Iterable<? extends T>>();

    private SequenceBuilder() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> SequenceBuilder<T> create() {
        SequenceBuilder<T> sequenceBuilder = new SequenceBuilder<T>();
        if (sequenceBuilder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder.create must not return null");
        }
        return sequenceBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> SequenceBuilder<T> create(T element) {
        SequenceBuilder<T> sequenceBuilder = new SequenceBuilder<T>().append(element);
        if (sequenceBuilder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder.create must not return null");
        }
        return sequenceBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> SequenceBuilder<T> create(Iterable<? extends T> element) {
        SequenceBuilder<? extends T> sequenceBuilder = new SequenceBuilder<T>().append(element);
        if (sequenceBuilder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder.create must not return null");
        }
        return sequenceBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> SequenceBuilder<T> create(Iterable<? extends T> ... elements) {
        SequenceBuilder<? extends T> result = new SequenceBuilder<T>();
        for (Iterable<? extends T> element : elements) {
            result.append(element);
        }
        SequenceBuilder<? extends T> sequenceBuilder = result;
        if (sequenceBuilder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder.create must not return null");
        }
        return sequenceBuilder;
    }

    public SequenceBuilder<T> append(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder.append must not be null");
        }
        this.iterables.add(Collections.singleton(element));
        return this;
    }

    public SequenceBuilder<T> append(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder.append must not be null");
        }
        this.iterables.add(iterable);
        return this;
    }

    public SequenceBuilder<T> appendFirst(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder.appendFirst must not be null");
        }
        this.iterables.add(0, iterable);
        return this;
    }

    public Sequence<T> build() {
        return new SequenceSet(this.iterables);
    }

    public Collection<T> toCollection() {
        return new SequenceSet(this.iterables);
    }

    private static class SequenceSet<T>
    extends AbstractCollection<T>
    implements Sequence<T> {
        @NotNull
        private final Iterable[] iterables;

        private SequenceSet(List<Iterable<? extends T>> iterables) {
            this.iterables = iterables.toArray(new Iterable[iterables.size()]);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Sequence<T> select(@NotNull Predicate<T> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder$SequenceSet.select must not be null");
            }
            Sequence<T> sequence = CollectionUtils.select(this, predicate);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder$SequenceSet.select must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <V extends T> Sequence<V> selectInstanceOf(@NotNull Class<V> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder$SequenceSet.selectInstanceOf must not be null");
            }
            Sequence<V> sequence = CollectionUtils.selectInstanceOf(this, clazz);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder$SequenceSet.selectInstanceOf must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <U> Sequence<U> map(@NotNull Function<T, U> mapper) {
            if (mapper == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder$SequenceSet.map must not be null");
            }
            Sequence<U> sequence = CollectionUtils.map(this, mapper);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder$SequenceSet.map must not return null");
            }
            return sequence;
        }

        @Override
        public boolean addAllTo(@NotNull Collection<? super T> c) {
            if (c == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder$SequenceSet.addAllTo must not be null");
            }
            return c.addAll(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <D extends T> Sequence<T> flatten(@NotNull Function<? super T, Iterator<D>> traversal) {
            if (traversal == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder$SequenceSet.flatten must not be null");
            }
            Sequence<? super T> sequence = CollectionUtils.flatten(this, traversal);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder$SequenceSet.flatten must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<T> iterator() {
            ChainedIterator chainedIterator = new ChainedIterator(this.iterables);
            if (chainedIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/SequenceBuilder$SequenceSet.iterator must not return null");
            }
            return chainedIterator;
        }

        @Override
        public int hashCode() {
            return CollectionUtils.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Sequence && CollectionUtils.equals(this, (Iterable)obj);
        }

        @Override
        public boolean isEmpty() {
            for (Iterable collection : this.iterables) {
                if (collection == null || !collection.iterator().hasNext()) continue;
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            int result = 0;
            for (Iterable collection : this.iterables) {
                if (collection == null) continue;
                result += CollectionUtils.size(collection);
            }
            return result;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return super.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private static class ChainedIterator
        extends NoRemoveIterator {
            @NotNull
            private Iterator currentIterator;
            private int index;
            @NotNull
            private final Iterable[] iterables;

            private ChainedIterator(@NotNull Iterable[] its) {
                if (its == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/SequenceBuilder$SequenceSet$ChainedIterator.<init> must not be null");
                }
                this.iterables = its;
                this.index = -1;
                this.currentIterator = CollectionUtils.emptyIterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.currentIterator.hasNext();
            }

            @Override
            public Object next() {
                Object result = this.currentIterator.next();
                this.advance();
                return result;
            }

            private void advance() {
                if (!this.currentIterator.hasNext()) {
                    this.currentIterator = CollectionUtils.emptyIterator();
                    while (++this.index < this.iterables.length) {
                        Iterable iterable = this.iterables[this.index];
                        if (iterable == null) continue;
                        this.currentIterator = iterable.iterator();
                        if (!this.currentIterator.hasNext()) continue;
                        break;
                    }
                }
            }
        }
    }
}

