/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import oracle.bpm.collections.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredicateUtils {
    private static final Predicate<?> TRUE = new Predicate<Object>(){

        @Override
        public boolean check(Object value) {
            return true;
        }
    };
    private static final Predicate<?> FALSE = new Predicate<Object>(){

        @Override
        public boolean check(Object value) {
            return false;
        }
    };
    private static final Predicate<?> NOT_NULL = new Predicate<Object>(){

        @Override
        public boolean check(Object value) {
            return value != null;
        }
    };
    private static final Predicate<?> NULL = new Predicate<Object>(){

        @Override
        public boolean check(Object value) {
            return value == null;
        }
    };

    private PredicateUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> truePredicate() {
        Predicate<?> predicate = TRUE;
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.truePredicate must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> falsePredicate() {
        Predicate<?> predicate = FALSE;
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.falsePredicate must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> notNull() {
        Predicate<?> predicate = NOT_NULL;
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.notNull must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> isNull() {
        Predicate<?> predicate = NULL;
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.isNull must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> equals(final @Nullable T object) {
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return object == value || object != null && value != null && object.equals(value);
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.equals must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> identity(final @Nullable T object) {
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return object == value;
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.identity must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> instanceOf(final @NotNull Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.instanceOf must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return value != null && type.isInstance(value);
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.instanceOf must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> not(final @NotNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.not must not be null");
        }
        Predicate predicate2 = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return !predicate.check(value);
            }
        };
        if (predicate2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.not must not return null");
        }
        return predicate2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> and(final @NotNull Predicate<T> predicateA, final @NotNull Predicate<T> predicateB) {
        if (predicateA == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.and must not be null");
        }
        if (predicateB == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.and must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return predicateA.check(value) && predicateB.check(value);
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.and must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> or(final @NotNull Predicate<T> predicateA, final @NotNull Predicate<T> predicateB) {
        if (predicateA == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.or must not be null");
        }
        if (predicateB == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.or must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return predicateA.check(value) || predicateB.check(value);
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.or must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> all(final Predicate<T> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.all must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                for (Predicate predicate : predicates) {
                    if (predicate.check(value)) continue;
                    return false;
                }
                return true;
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.all must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> any(final Predicate<T> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.any must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                for (Predicate predicate : predicates) {
                    if (!predicate.check(value)) continue;
                    return true;
                }
                return false;
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.any must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> either(final @NotNull Predicate<T> predicateA, final @NotNull Predicate<T> predicateB) {
        if (predicateA == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.either must not be null");
        }
        if (predicateB == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.either must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return predicateA.check(value) ? !predicateB.check(value) : predicateB.check(value);
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.either must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> one(final Predicate<T> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.one must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                boolean oneTrue = false;
                for (Predicate predicate : predicates) {
                    if (!predicate.check(value)) continue;
                    if (oneTrue) {
                        return false;
                    }
                    oneTrue = true;
                }
                return oneTrue;
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.one must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> neither(final @NotNull Predicate<T> predicateA, final @NotNull Predicate<T> predicateB) {
        if (predicateA == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.neither must not be null");
        }
        if (predicateB == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.neither must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                return !predicateA.check(value) && !predicateB.check(value);
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.neither must not return null");
        }
        return predicate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Predicate<T> none(final Predicate<T> ... predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/PredicateUtils.none must not be null");
        }
        Predicate predicate = new Predicate<T>(){

            @Override
            public boolean check(T value) {
                for (Predicate predicate : predicates) {
                    if (!predicate.check(value)) continue;
                    return false;
                }
                return true;
            }
        };
        if (predicate == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/PredicateUtils.none must not return null");
        }
        return predicate;
    }
}

