/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.adapter.AdapterFactory;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.adapter.annotation.Adapter;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;

public class DefaultAdapterService
implements AdapterService {
    protected Map<Class, Map<Class, AdapterFactory>> cache = new HashMap<Class, Map<Class, AdapterFactory>>();
    protected Map<Class, List<AdapterFactory>> factories = new HashMap<Class, List<AdapterFactory>>();

    public DefaultAdapterService() {
        this.registerFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFactory(AdapterFactory adapter) {
        Map<Class, List<AdapterFactory>> map = this.factories;
        synchronized (map) {
            Class sourceClass = adapter.getSourceClass();
            List<AdapterFactory> list = this.factories.get(sourceClass);
            if (list == null) {
                list = new ArrayList<AdapterFactory>();
                this.factories.put(sourceClass, list);
            }
            list.add(adapter);
        }
    }

    @Override
    public <T> T adaptTo(Object object, Class<T> targetClass) {
        T result = null;
        if (object == null) {
            result = null;
        } else {
            Class<?> objectClass = object.getClass();
            if (targetClass.isAssignableFrom(objectClass)) {
                result = targetClass.cast(object);
            } else {
                AdapterFactory adapter;
                if (object instanceof Adaptable) {
                    Adaptable adaptable = (Adaptable)object;
                    result = adaptable.as(targetClass);
                }
                if (result == null && (adapter = this.findAdapterTo(objectClass, targetClass)) != null) {
                    T value = adapter.adapt(object, targetClass);
                    result = targetClass.cast(value);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AdapterFactory findAdapterTo(Class sourceClass, Class targetClass) {
        AdapterFactory result;
        Map<Class, List<AdapterFactory>> map = this.factories;
        synchronized (map) {
            Map<Class, AdapterFactory> factoryByTargetClass = this.cache.get(sourceClass);
            if (factoryByTargetClass == null) {
                factoryByTargetClass = new HashMap<Class, AdapterFactory>();
                this.cache.put(sourceClass, factoryByTargetClass);
            }
            if ((result = factoryByTargetClass.get(targetClass)) == null && (result = this.selectBestFactory(sourceClass, targetClass)) != null) {
                factoryByTargetClass.put(targetClass, result);
            }
        }
        return result;
    }

    protected void registerFactories() {
        ExtensionService extensionService = Platform.getExtensionService();
        List<Extension<Adapter>> extensions = extensionService.getExtensionsByPoint(Adapter.class);
        for (Extension<Adapter> extension : extensions) {
            try {
                AdapterFactory factory = extension.instantiateAs(AdapterFactory.class);
                this.registerFactory(factory);
            }
            catch (Throwable unexpected) {
                Log.logWarning(unexpected);
            }
        }
    }

    private AdapterFactory selectBestFactory(Class sourceClass, Class targetClass) {
        AdapterFactory result = null;
        ArrayList sources = new ArrayList();
        sources.add(sourceClass);
        while (result == null && !sources.isEmpty()) {
            Class source = (Class)sources.remove(0);
            List<AdapterFactory> list = this.factories.get(source);
            if (list != null) {
                for (AdapterFactory factory : list) {
                    if (!this.canAdaptTo(factory, targetClass)) continue;
                    result = factory;
                    break;
                }
            }
            if (result != null) continue;
            Class superclass = source.getSuperclass();
            if (superclass != null) {
                sources.add(superclass);
            }
            for (Class<?> iface : source.getInterfaces()) {
                sources.add(iface);
            }
        }
        return result;
    }

    private boolean canAdaptTo(AdapterFactory factory, Class targetClass) {
        boolean result = false;
        List<Class> classes = factory.getTargetClasses();
        for (Class cl : classes) {
            if (!targetClass.isAssignableFrom(cl)) continue;
            result = true;
            break;
        }
        return result;
    }
}

