/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.metadata.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bpm.analytics.LogUtil;
import oracle.bpm.analytics.measurement.IMeasurementConstants;
import oracle.bpm.analytics.measurement.MeasurementCacheInitializationException;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataCache;
import oracle.bpm.analytics.measurement.metadata.MeasurementMetadataUtil;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementActionCacheElement;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementCacheElement;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.analytics.measurement.metadata.model.TElementState;
import oracle.bpm.analytics.measurement.metadata.model.TElementType;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElement;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.blocks.mesh.FabricMesh;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.kernel.FabricMeshUtils;

public class MeasurementMetadataCache
implements IMeasurementMetadataCache,
IMeasurementConstants {
    ConcurrentHashMap<String, List<MeasurementActionCacheElement>> measurementActionCache;
    ConcurrentHashMap<String, List<MeasurementCacheElement>> measurementEnableCache = new ConcurrentHashMap();
    private static final String logClassName = MeasurementMetadataCache.class.getName();
    private static MeasurementMetadataCache cacheInstance = null;

    private MeasurementMetadataCache(boolean isTestSuite) throws MeasurementCacheInitializationException {
        this.measurementActionCache = new ConcurrentHashMap();
        if (!isTestSuite) {
            this.initialize();
        }
    }

    public static synchronized MeasurementMetadataCache getCacheInstance() throws MeasurementCacheInitializationException {
        if (cacheInstance == null) {
            cacheInstance = new MeasurementMetadataCache(false);
        }
        return cacheInstance;
    }

    public static synchronized MeasurementMetadataCache getCacheInstance(boolean isTestSuite) throws MeasurementCacheInitializationException {
        if (cacheInstance == null) {
            cacheInstance = new MeasurementMetadataCache(isTestSuite);
        }
        return cacheInstance;
    }

    @Override
    public List<MeasurementCacheElement> getMeasurement(String measurementKey) {
        String logMethodName = "getMeasurement";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurement", (String)("BEGIN: getMeasurement Measurement Key is :" + measurementKey + "\n Cache Key Set is:" + this.measurementEnableCache.keySet()));
        List<MeasurementCacheElement> measurementList = null;
        if (measurementKey.endsWith("_DUMMY_TEMP_ACTIVITY_")) {
            String finalMeasurementKey = measurementKey.substring(0, measurementKey.lastIndexOf("_DUMMY_TEMP_ACTIVITY_"));
            for (String key : this.measurementEnableCache.keySet()) {
                if (!key.startsWith(finalMeasurementKey)) continue;
                measurementList = new ArrayList<MeasurementCacheElement>();
                measurementList.addAll((Collection<MeasurementCacheElement>)this.measurementEnableCache.get(key));
            }
        } else {
            measurementList = this.measurementEnableCache.get(measurementKey);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurement", (String)"END");
        return measurementList;
    }

    @Override
    public List<MeasurementActionCacheElement> getAction(String actionKey) {
        String logMethodName = "getAction";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction", (String)("BEGIN: getMeasurement Measurement Key is :" + actionKey + "\n Acgtion Cache Key Set is:" + this.measurementActionCache.keySet()));
        List<MeasurementActionCacheElement> actionList = this.measurementActionCache.get(actionKey);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction", (String)"END");
        return actionList;
    }

    @Override
    public void addToCache(ComponentModel componentModel) {
        String logMethodName = "addToCache";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)"BEGIN");
        try {
            CompositeModel composite = componentModel.getComposite();
            String dn = composite.getDN();
            boolean existInCache = this.isDnExistInCache(dn);
            if (!existInCache) {
                List elem;
                InputStream in;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)"******** CACHE BEFORE DEPLOYMENT *****");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)this.printCacheData().toString());
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)this.printActionCacheData().toString());
                try {
                    in = composite.getMetadataManager().getDocumentAsInputStream("measurements.xml");
                    if (in != null) {
                        elem = MeasurementMetadataUtil.getMeasurementElements(in);
                        if (elem != null && elem.size() >= 2) {
                            this.addMeasurementToCache(dn, (List)elem.get(1));
                        } else {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)("Measurement Element for DN" + dn + "is null"));
                        }
                    } else {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)("In put stream for measuremnet.xml is null, Composite Dn = " + dn));
                    }
                }
                catch (Exception e) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)("measuremnet.xml does not exist for Composite Dn = " + dn));
                }
                try {
                    in = composite.getMetadataManager().getDocumentAsInputStream("measurementActions.xml");
                    if (in != null) {
                        elem = MeasurementMetadataUtil.getActionElements(in);
                        if (elem != null && elem.size() >= 2) {
                            this.addActionToCache(dn, (List)elem.get(1));
                        } else {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)("Measurement Action Element for DN" + dn + "is null"));
                        }
                    } else {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)("In put stream for measurementAction.xml is null, Composite Dn = " + dn));
                    }
                }
                catch (Exception e) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)("measurementAction.xml does not exist for Composite Dn = " + dn));
                }
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)"******** CACHE AFTER DEPLOYMENT  *****");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)this.printCacheData().toString());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)this.printActionCacheData().toString());
        }
        catch (Exception e1) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "addToCache");
            exCtx.setErrorCode(50102);
            exCtx.setSeverity(Severity.ERRORS);
            BPMException exBpm = new BPMException(exCtx);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addToCache", (String)"END");
    }

    @Override
    public void removeFromCache(ComponentModel componentModel) {
        String logMethodName = "removeFromCache";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)("BEGIN Remove element from cache with DN:" + componentModel.getComposite()));
        CompositeModel compModel = componentModel.getComposite();
        String compositeDN = compModel.getDN();
        this.removeFromCache(compositeDN);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)"END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromCache(String compositeDN) {
        String logMethodName = "removeFromCache";
        boolean removeFromActionCache = false;
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)"******** CACHE BEFORE REMOVE *****");
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)this.printCacheData().toString());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)this.printActionCacheData().toString());
        ConcurrentHashMap<String, List<Object>> concurrentHashMap = this.measurementEnableCache;
        synchronized (concurrentHashMap) {
            if (this.isDnExistInCache(compositeDN)) {
                removeFromActionCache = true;
                this.removeAllStartWithKey(this.measurementEnableCache, compositeDN);
            }
        }
        concurrentHashMap = this.measurementActionCache;
        synchronized (concurrentHashMap) {
            if (removeFromActionCache) {
                removeFromActionCache = false;
                this.removeAllStartWithKey(this.measurementActionCache, compositeDN);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)"******** CACHE AFTER EMOVE *****");
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)this.printCacheData().toString());
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeFromCache", (String)this.printActionCacheData().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMeasurementToCache(String compositeDN, List elems) {
        String logMethodName = "addMeasurementToCache";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addMeasurementToCache", (String)("BEGIN add Measurement to Cache for compositeDN:" + compositeDN + "\n Element List size :" + elems.size()));
        String key = null;
        for (Object elem : elems) {
            if (((TMeasurementElement)elem).isEnabled()) {
                String temp;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addMeasurementToCache", (String)("Measurement is enabled for element ==>" + ((TMeasurementElement)elem).getName()));
                TreeSet<String> elementStateSet = new TreeSet<String>();
                TreeSet<String> elementTypeSet = new TreeSet<String>();
                String elementSelection = "";
                key = compositeDN;
                if (((TMeasurementElement)elem).getElementStates() != null) {
                    List<TElementState> elementStates = ((TMeasurementElement)elem).getElementStates().getElementState();
                    for (TElementState tElementState : elementStates) {
                        temp = tElementState.value();
                        elementStateSet.add(temp.trim());
                    }
                }
                if (((TMeasurementElement)elem).getElementTypes() != null) {
                    List<TElementType> elementTypes = ((TMeasurementElement)elem).getElementTypes().getElementType();
                    for (Enum enum_ : elementTypes) {
                        temp = ((TElementType)enum_).value();
                        elementTypeSet.add(temp.trim());
                    }
                }
                if (((TMeasurementElement)elem).getElementSelection() != null) {
                    elementSelection = ((TMeasurementElement)elem).getElementSelection().value();
                }
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addMeasurementToCache", (String)("Element Type Set is :" + elementTypeSet + "Element State Set is :" + elementStateSet + "Element Selection is :" + elementSelection));
                String measurementElelmebtName = ((TMeasurementElement)elem).getName();
                if (((TMeasurementElement)elem).getComponentName() != null) {
                    key = key + ((TMeasurementElement)elem).getComponentName();
                }
                if (((TMeasurementElement)elem).getElementId() != null) {
                    key = key + ((TMeasurementElement)elem).getElementId();
                }
                MeasurementCacheElement measurementCacheElement = new MeasurementCacheElement();
                measurementCacheElement.setElementState(elementStateSet);
                measurementCacheElement.setElementType(elementTypeSet);
                measurementCacheElement.setElementSelection(elementSelection);
                measurementCacheElement.setMeasurementElementName(measurementElelmebtName);
                List<MeasurementCacheElement> cacheDataList = this.measurementEnableCache.get(key);
                if (cacheDataList == null) {
                    cacheDataList = new ArrayList<MeasurementCacheElement>();
                }
                cacheDataList.add(measurementCacheElement);
                ConcurrentHashMap<String, List<MeasurementCacheElement>> concurrentHashMap = this.measurementEnableCache;
                synchronized (concurrentHashMap) {
                    this.measurementEnableCache.put(key, cacheDataList);
                    continue;
                }
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addMeasurementToCache", (String)("Measurement is not enabled for element ==>" + ((TMeasurementElement)elem).getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionToCache(String compositeDN, List actionList) {
        String logMethodName = "addActionToCache";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addActionToCache", (String)"BEGIN:");
        if (actionList != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.INFORMATION, (String)logClassName, (String)"addActionToCache", (String)("measuremnet Action List size is:" + actionList.size()));
            for (Object action : actionList) {
                List<String> measurementElementName = ((TAction)action).getMeasurementElementName();
                String actionName = ((TAction)action).getName();
                for (String elementName : measurementElementName) {
                    String key = compositeDN + elementName;
                    ConcurrentHashMap<String, List<MeasurementActionCacheElement>> concurrentHashMap = this.measurementActionCache;
                    synchronized (concurrentHashMap) {
                        MeasurementActionCacheElement elem = new MeasurementActionCacheElement();
                        elem.setActionName(actionName);
                        elem.setAction((TAction)action);
                        List<MeasurementActionCacheElement> cacheActionList = this.measurementActionCache.get(key);
                        if (cacheActionList == null) {
                            cacheActionList = new ArrayList<MeasurementActionCacheElement>();
                        }
                        cacheActionList.add(elem);
                        this.measurementActionCache.put(key, cacheActionList);
                    }
                }
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"addActionToCache", (String)"END:");
    }

    public StringBuffer printActionCacheData() {
        StringBuffer strBuffer = new StringBuffer(MeasurementMetadataCache.getLineString(170));
        strBuffer.append("\n");
        strBuffer.append("|-KEY" + this.getSpaceString(88) + "|-" + "Action Name" + this.getSpaceString(17) + "|" + "|-" + "Enabled" + this.getSpaceString(12) + "|");
        strBuffer.append("\n");
        strBuffer.append(MeasurementMetadataCache.getLineString(150));
        strBuffer.append("\n");
        Set keySet = this.measurementActionCache.keySet();
        for (String keyFromMap : keySet) {
            List<MeasurementActionCacheElement> cacheElemList = this.measurementActionCache.get(keyFromMap);
            int keySize = keyFromMap.length();
            int keySizea = 0;
            int keySizeb = 0;
            if (keySize < 90) {
                keySize = 90 - keySize;
            } else {
                keyFromMap = keyFromMap.substring(0, 89);
                keySize = 0;
            }
            if (keySize % 2 == 1) {
                keySizea = (keySize + 1) / 2;
                keySizeb = (keySize - 1) / 2;
            } else {
                keySizea = keySize / 2;
                keySizeb = keySize / 2;
            }
            for (int i = 0; i < cacheElemList.size(); ++i) {
                MeasurementActionCacheElement cacheElem = cacheElemList.get(i);
                String actionName = cacheElem.getActionName();
                boolean enabled = cacheElem.getAction().isEnabled();
                if (actionName == null) {
                    actionName = "";
                }
                int actionNamesize = actionName.length();
                int actionNamesizea = 0;
                int actionNamesizeb = 0;
                if (actionNamesize < 30) {
                    actionNamesize = 30 - actionNamesize;
                }
                if (actionNamesize % 2 == 1) {
                    actionNamesizea = (actionNamesize + 1) / 2;
                    actionNamesizeb = (actionNamesize - 1) / 2;
                } else {
                    actionNamesizea = actionNamesize / 2;
                    actionNamesizeb = actionNamesize / 2;
                }
                String enableString = new Boolean(enabled).toString();
                int enabledsize = enableString.length();
                int enabledsizea = 0;
                int enabledsizeb = 0;
                if (enabledsize < 25) {
                    enabledsize = 25 - actionNamesize;
                }
                if (enabledsize % 2 == 1) {
                    enabledsizea = (enabledsize + 1) / 2;
                    enabledsizeb = (enabledsize - 1) / 2;
                } else {
                    enabledsizea = enabledsize / 2;
                    enabledsizeb = enabledsize / 2;
                }
                strBuffer.append("\n");
                strBuffer.append("|" + this.getSpaceString(keySizea) + keyFromMap + this.getSpaceString(keySizeb) + "|" + this.getSpaceString(actionNamesizea) + actionName + this.getSpaceString(actionNamesizeb) + "|" + "|" + this.getSpaceString(enabledsizea) + enableString + this.getSpaceString(enabledsizeb) + "|");
                strBuffer.append("\n");
            }
        }
        return strBuffer;
    }

    public StringBuffer printCacheData() {
        StringBuffer strBuffer = new StringBuffer(MeasurementMetadataCache.getLineString(170));
        strBuffer.append("\n");
        strBuffer.append("|-KEY" + this.getSpaceString(67) + "|-" + "Element Type" + this.getSpaceString(7) + "|-" + "Element State" + this.getSpaceString(16) + "|-" + "Element Selection" + this.getSpaceString(2) + "|-" + "Element Name" + this.getSpaceString(6) + " |");
        strBuffer.append("\n");
        strBuffer.append(MeasurementMetadataCache.getLineString(170));
        strBuffer.append("\n");
        Set keySet = this.measurementEnableCache.keySet();
        for (String keyFromMap : keySet) {
            List<MeasurementCacheElement> measurementElementList = this.measurementEnableCache.get(keyFromMap);
            int keySize = keyFromMap.length();
            int keySizea = 0;
            int keySizeb = 0;
            if (keySize < 70) {
                keySize = 70 - keySize;
            } else {
                keyFromMap = keyFromMap.substring(0, 69);
                keySize = 0;
            }
            if (keySize % 2 == 1) {
                keySizea = (keySize + 1) / 2;
                keySizeb = (keySize - 1) / 2;
            } else {
                keySizea = keySize / 2;
                keySizeb = keySize / 2;
            }
            for (int i = 0; i < measurementElementList.size(); ++i) {
                String mesElementName;
                String elementSelection;
                String elementState;
                MeasurementCacheElement element = measurementElementList.get(i);
                String elementType = element.getElementType().toString();
                if (elementType == null) {
                    elementType = "";
                }
                if ((elementState = element.getElementState().toString()) == null) {
                    elementState = "";
                }
                if ((elementSelection = element.getElementSelection()) == null) {
                    elementSelection = "";
                }
                if ((mesElementName = element.getMeasurementElementName()) == null) {
                    mesElementName = "";
                }
                int elementTypesize = elementType.length();
                int elementTypesizea = 0;
                int elementTypesizeb = 0;
                if (elementTypesize < 20) {
                    elementTypesize = 20 - elementTypesize;
                }
                if (elementTypesize % 2 == 1) {
                    elementTypesizea = (elementTypesize + 1) / 2;
                    elementTypesizeb = (elementTypesize - 1) / 2;
                } else {
                    elementTypesizea = elementTypesize / 2;
                    elementTypesizeb = elementTypesize / 2;
                }
                int elementStatesize = elementState.length();
                int elementStatesizea = 0;
                int elementStatesizeb = 0;
                if (elementStatesize < 30) {
                    elementStatesize = 30 - elementStatesize;
                }
                if (elementStatesize % 2 == 1) {
                    elementStatesizea = (elementStatesize + 1) / 2;
                    elementStatesizeb = (elementStatesize - 1) / 2;
                } else {
                    elementStatesizea = elementStatesize / 2;
                    elementStatesizeb = elementStatesize / 2;
                }
                int elementSelectionsize = elementSelection.length();
                int elementSelectionsizea = 0;
                int elementSelectionsizeb = 0;
                if (elementSelectionsize < 20) {
                    elementSelectionsize = 20 - elementSelectionsize;
                }
                if (elementSelectionsize % 2 == 1) {
                    elementSelectionsizea = (elementSelectionsize + 1) / 2;
                    elementSelectionsizeb = (elementSelectionsize - 1) / 2;
                } else {
                    elementSelectionsizea = elementSelectionsize / 2;
                    elementSelectionsizeb = elementSelectionsize / 2;
                }
                int measurementElementNamesize = mesElementName.length();
                int measurementElementNamesizea = 0;
                int measurementElementNamesizeb = 0;
                if (measurementElementNamesize < 20) {
                    measurementElementNamesize = 20 - measurementElementNamesize;
                }
                if (measurementElementNamesize % 2 == 1) {
                    measurementElementNamesizea = (measurementElementNamesize + 1) / 2;
                    measurementElementNamesizeb = (measurementElementNamesize - 1) / 2;
                } else {
                    measurementElementNamesizea = measurementElementNamesize / 2;
                    measurementElementNamesizeb = measurementElementNamesize / 2;
                }
                strBuffer.append("|" + this.getSpaceString(keySizea) + keyFromMap + this.getSpaceString(keySizeb) + "|" + this.getSpaceString(elementTypesizea) + elementType + this.getSpaceString(elementTypesizeb) + "|" + this.getSpaceString(elementStatesizea) + elementState + this.getSpaceString(elementStatesizeb) + "|" + this.getSpaceString(elementSelectionsizea) + elementSelection + this.getSpaceString(elementSelectionsizeb) + "|" + this.getSpaceString(measurementElementNamesizea) + mesElementName + this.getSpaceString(measurementElementNamesizeb) + "|");
                strBuffer.append("\n");
                strBuffer.append(MeasurementMetadataCache.getLineString(170));
                strBuffer.append("\n");
            }
        }
        return strBuffer;
    }

    private static String getLineString(int size) {
        String space = "";
        for (int i = 0; i < size; ++i) {
            space = space + "-";
        }
        return space;
    }

    private void initialize() throws MeasurementCacheInitializationException {
        String logMethodName = "initialize";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)"BEGIN - Cache Initilization");
        try {
            FabricMesh mesh = (FabricMesh)FabricMeshUtils.getApplicationContext().getBean("FabricMesh");
            List composites = mesh.listComposites();
            for (CompositeModel composite1 : composites) {
                List elem;
                InputStream in;
                String dn = composite1.getDN();
                try {
                    in = composite1.getMetadataManager().getDocumentAsInputStream("measurements.xml");
                    if (in != null) {
                        elem = MeasurementMetadataUtil.getMeasurementElements(in);
                        if (elem != null && elem.size() >= 2) {
                            this.addMeasurementToCache(dn, (List)elem.get(1));
                        } else {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)("Measurement Element for DN" + dn + "is null"));
                        }
                    } else {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)("In put stream for measuremnet.xml is null, Composite Dn = " + dn));
                    }
                }
                catch (Exception e) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)("measuremnet.xml does not exist for Composite Dn = " + dn));
                }
                try {
                    in = composite1.getMetadataManager().getDocumentAsInputStream("measurementActions.xml");
                    if (in != null) {
                        elem = MeasurementMetadataUtil.getActionElements(in);
                        if (elem != null && elem.size() >= 2) {
                            this.addActionToCache(dn, (List)elem.get(1));
                        } else {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)("Measurement Action Element for DN " + dn + "is null"));
                        }
                    } else {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)("In put stream for measurementAcyion.xml is null, Composite Dn = " + dn));
                    }
                }
                catch (Exception e) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"initialize", (String)("measurementAction.xml does not exist for Composite Dn = " + dn));
                }
                LogUtil.logMessage(this.getClass().getName(), " compositeDn is ==>" + composite1.getDN());
                LogUtil.logMessage(this.getClass().getName(), " compositeDn state is ==>" + composite1.getState());
            }
        }
        catch (Exception e1) {
            LogUtil.logMessage(this.getClass().getName(), " error message===>" + e1.getMessage());
        }
    }

    private boolean isDnExistInCache(String dn) {
        Set keySet = this.measurementEnableCache.keySet();
        for (String keyFromMap : keySet) {
            if (!keyFromMap.startsWith(dn)) continue;
            return true;
        }
        return false;
    }

    private void removeAllStartWithKey(ConcurrentHashMap map, String compositeDN) {
        String logMethodName = "removeAllStartWithKey";
        Set keySet = map.keySet();
        Iterator keySetIterator = keySet.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (keySetIterator.hasNext()) {
            String keyFromMap = (String)keySetIterator.next();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"removeAllStartWithKey", (String)("For DN:" + compositeDN + "Candidate Map key for deletion is:" + keyFromMap));
            if (!keyFromMap.startsWith(compositeDN)) continue;
            list.add(keyFromMap);
        }
        if (!list.isEmpty()) {
            Iterator listIterator = list.iterator();
            while (listIterator.hasNext()) {
                map.remove(listIterator.next());
            }
        }
    }

    private String getSpaceString(int size) {
        String space = "";
        for (int i = 0; i < size; ++i) {
            space = space + " ";
        }
        return space;
    }
}

