/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Function;
import oracle.bpm.fusion.sca.Utils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.project.model.ProjectRepository;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.fabric.addin.CompositeModel;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.model.SCAComponent;
import oracle.tip.tools.ide.fabric.model.SCAComponentType;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAImplementation;
import oracle.tip.tools.ide.fabric.model.SCAImports;
import oracle.tip.tools.ide.fabric.model.SCAInterface;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilder;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilderException;
import oracle.tip.tools.ide.fabric.model.SCAReference;
import oracle.tip.tools.ide.fabric.model.SCAService;
import oracle.tip.tools.ide.fabric.model.WSDLInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdevCompositeAccessor
extends CompositeAccessor {
    private SCAComposite scaComposite;
    private SCAController scaController;
    private static final QName HUMAN_TASK_INTERFACE_QNAME = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskService");
    private static final String BUSINESS_RULE_INTERFACE_NAMESPACE = "http://xmlns.oracle.com/RuleDictionary/";
    private static final String BUSINESS_RULE_INTERFACE_NAME = "IDecisionService";

    public JdevCompositeAccessor(@NotNull oracle.bpm.project.model.Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor.<init> must not be null");
        }
        super(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CompositeInfo parseComposite() throws CompositeAccessorException {
        this.loadComposite();
        CompositeInfo compositeInfo = new CompositeInfo(this.getCompositeReferences(), this.getCompositeServices(), this.getCompositeComponents(), this.getCompositeImports());
        if (compositeInfo == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.parseComposite must not return null");
        }
        return compositeInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeInterface> getCompositeReferences() {
        SCAComposite composite = this.getScaComposite();
        List scaReferences = composite != null ? composite.getReferences() : new ArrayList();
        Iterable iterable = this.nonNullIterable(scaReferences, new Function<SCAReference, CompositeInterface>(){

            @Override
            public CompositeInterface eval(SCAReference scaReference) {
                return JdevCompositeAccessor.this.createInterface(new ElementContainer(JdevCompositeAccessor.this.getVFileSystemProject(), JdevCompositeAccessor.this.getScaController(), scaReference), scaReference.getName(), null, CatalogInterfaceType.SERVICE, null);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeReferences must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeInterface> getCompositeServices() {
        SCAComposite composite = this.getScaComposite();
        List scaServices = composite != null ? composite.getServices() : new ArrayList();
        Iterable iterable = this.nonNullIterable(scaServices, new Function<SCAService, CompositeInterface>(){

            @Override
            public CompositeInterface eval(SCAService scaService) {
                return JdevCompositeAccessor.this.createInterface(new ElementContainer(JdevCompositeAccessor.this.getVFileSystemProject(), JdevCompositeAccessor.this.getScaController(), scaService), scaService.getName(), null, CatalogInterfaceType.REFERENCE, null);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeServices must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeComponent> getCompositeComponents() {
        SCAComposite composite = this.getScaComposite();
        List componentList = composite != null ? composite.getComponents() : new ArrayList();
        Iterable iterable = this.nonNullIterable(componentList, new Function<SCAComponent, CompositeComponent>(){

            @Override
            public CompositeComponent eval(SCAComponent scaComponent) {
                return JdevCompositeAccessor.this.createComponent(scaComponent);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeComponents must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Iterable<CompositeImport> getCompositeImports() {
        SCAComposite composite = this.getScaComposite();
        List scaImports = composite != null ? composite.getImports() : new ArrayList();
        Iterable iterable = this.nonNullIterable(scaImports, new Function<SCAImports, CompositeImport>(){

            @Override
            public CompositeImport eval(SCAImports value) {
                return JdevCompositeAccessor.this.createImport(value);
            }
        });
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor.getCompositeImports must not return null");
        }
        return iterable;
    }

    private CompositeImport createImport(SCAImports value) {
        return new CompositeImport(value.getNamespace().toString(), value.getLocation(), value.getImportType());
    }

    private void loadComposite() throws CompositeAccessorException {
        Project devProject = this.getJDevProject();
        try {
            if (devProject != null && CompositeModel.getCompositeModel((Project)devProject) != null) {
                this.scaComposite = SCAModelBuilder.getSCAModelBuilder((Project)devProject).reloadSCAComposite();
                this.scaController = SCAControllerImpl.getController((Project)devProject);
            }
        }
        catch (SCAModelBuilderException e) {
            throw new CompositeAccessorException(ProjectCatalogMsg.ERROR_LOADING_COMPOSITE_DATA, (Throwable)e);
        }
    }

    @Nullable
    private SCAController getScaController() {
        return this.scaController;
    }

    @Nullable
    private SCAComposite getScaComposite() {
        return this.scaComposite;
    }

    @Nullable
    private CompositeComponent createComponent(@NotNull SCAComponent scaComponent) {
        if (scaComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor.createComponent must not be null");
        }
        String name = scaComponent.getName();
        SCAImplementation implementation = scaComponent.getImplementation();
        SCAComponentType type = scaComponent.getComponentType();
        String srcLocation = implementation != null ? implementation.getSrcURI().toString() : null;
        CompositeServiceType serviceType = this.getType(implementation);
        Map<String, ScaPropertyInfo> properties = this.buildPropertyMap(scaComponent.getName(), null);
        CompositeComponent component = new CompositeComponent(name, serviceType, srcLocation, properties);
        if (implementation != null) {
            List references;
            SCAController controller = this.getScaController();
            VFileSystem fileSystemProject = this.getVFileSystemProject();
            List services = type.getServices();
            if (services != null) {
                for (SCAService service : services) {
                    ElementContainer elemContainer = new ElementContainer(fileSystemProject, controller, name, service);
                    Map<String, ScaPropertyInfo> propertyInfoMap = this.buildPropertyMap(scaComponent.getName(), service.getName());
                    CompositeInterface externalInterface = this.createInterface(elemContainer, name, service.getName(), CatalogInterfaceType.SERVICE, propertyInfoMap);
                    if (externalInterface == null) continue;
                    component.addService(externalInterface);
                }
            }
            if ((references = type.getReferences()) != null) {
                for (SCAReference reference : references) {
                    ElementContainer elemContainer = new ElementContainer(fileSystemProject, controller, name, reference);
                    Map<String, ScaPropertyInfo> propertyInfoMap = this.buildPropertyMap(scaComponent.getName(), reference.getName());
                    CompositeInterface externalInterface = this.createInterface(elemContainer, name, reference.getName(), CatalogInterfaceType.REFERENCE, propertyInfoMap);
                    if (externalInterface == null) continue;
                    component.addReference(externalInterface);
                }
            }
        }
        return component;
    }

    private Map<String, ScaPropertyInfo> buildPropertyMap(String componentName, String serviceOrReferenceName) {
        Map<String, ScaPropertyInfo> result;
        List propertyInfos = this.scaController.getComponentTypeProperties(componentName, serviceOrReferenceName);
        if (propertyInfos != null && !propertyInfos.isEmpty()) {
            result = new HashMap<String, ScaPropertyInfo>();
            for (PropertyInfo propertyInfo : propertyInfos) {
                ScaPropertyInfo scaPropertyInfo = Utils.convert(propertyInfo);
                result.put(scaPropertyInfo.name, scaPropertyInfo);
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Project getJDevProject() throws CompositeAccessorException {
        Project result;
        oracle.bpm.project.model.Project project = this.getProject();
        ProjectRepository repository = project.getRepository();
        if (repository == null) {
            result = null;
        } else {
            result = Platform.getAdapterService().adaptTo(project, Project.class);
            if (result == null) {
                throw new CompositeAccessorException(ProjectCatalogMsg.CANNOT_LOAD_JDEV_PROJECT((String)project.getName()));
            }
        }
        return result;
    }

    private CompositeServiceType getType(@Nullable SCAImplementation type) {
        if (type == null) {
            return CompositeServiceType.UNKNOWN;
        }
        return CompositeServiceType.parse((String)type.getImplementationType());
    }

    private static class ElementContainer
    implements CompositeAccessor.CompositeObjectContainer {
        private String componentName;
        private SCAReference reference;
        private SCAController scaController;
        private SCAService service;
        private VFileSystem vfileSystem;

        ElementContainer(@NotNull VFileSystem vfileSystem, SCAController scaController, @NotNull SCAReference reference) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (reference == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.reference = null;
            this.scaController = null;
            this.service = null;
            this.vfileSystem = null;
            this.scaController = scaController;
            this.reference = reference;
            this.vfileSystem = vfileSystem;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, SCAController scaController, @NotNull SCAService service) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (service == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.reference = null;
            this.scaController = null;
            this.service = null;
            this.vfileSystem = null;
            this.scaController = scaController;
            this.service = service;
            this.vfileSystem = vfileSystem;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, SCAController scaController, @NotNull String componentName, @NotNull SCAReference reference) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (reference == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.reference = null;
            this.scaController = null;
            this.service = null;
            this.vfileSystem = null;
            this.scaController = scaController;
            this.reference = reference;
            this.componentName = componentName;
            this.vfileSystem = vfileSystem;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, SCAController scaController, @NotNull String componentName, @NotNull SCAService service) {
            if (vfileSystem == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (componentName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            if (service == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.<init> must not be null");
            }
            this.componentName = null;
            this.reference = null;
            this.scaController = null;
            this.service = null;
            this.vfileSystem = null;
            this.scaController = scaController;
            this.service = service;
            this.componentName = componentName;
            this.vfileSystem = vfileSystem;
        }

        public String getName() {
            return this.service != null ? this.service.getName() : this.reference.getName();
        }

        public QName getInterfaceQName() {
            return this.getInterface().getInterfaceQName();
        }

        public QName getCallbankInterfaceQName() {
            return this.getInterface().getCallbankInterfaceQName();
        }

        public URL getWsdl() {
            URL url = null;
            if (this.scaController != null) {
                String location;
                String name;
                String linkName = null;
                if (this.componentName == null) {
                    name = this.getName();
                } else {
                    name = this.componentName;
                    linkName = this.getName();
                }
                WsdlInfo wsdlInfo = this.scaController.getWsdlInfoForName(name, linkName);
                if (wsdlInfo != null && (location = wsdlInfo.getWsdlLocation()) != null) {
                    try {
                        url = new URL(location);
                    }
                    catch (MalformedURLException e) {
                        VFile file = this.vfileSystem.createFile(location);
                        try {
                            url = file.toURL();
                        }
                        catch (IOException e1) {
                            url = null;
                        }
                    }
                }
            }
            if (url == null && this.service != null) {
                url = this.service.getWsdlUrl();
            }
            return url;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public CompositeServiceType getInterfaceType() {
            QName qName;
            CompositeServiceType result = CompositeServiceType.WEB_SERVICE;
            SCAInterface scaInterface = this.getInterface();
            if (scaInterface != null && scaInterface instanceof WSDLInterface && (qName = scaInterface.getInterfaceQName()) != null) {
                if (qName.equals(HUMAN_TASK_INTERFACE_QNAME)) {
                    result = CompositeServiceType.HUMAN_TASK;
                } else {
                    String namespace = qName.getNamespaceURI();
                    String localPart = qName.getLocalPart();
                    if (namespace.startsWith(JdevCompositeAccessor.BUSINESS_RULE_INTERFACE_NAMESPACE) && localPart.equals(JdevCompositeAccessor.BUSINESS_RULE_INTERFACE_NAME)) {
                        result = CompositeServiceType.BUSINESS_RULE;
                    }
                }
            }
            CompositeServiceType compositeServiceType = result;
            if (compositeServiceType == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/sca/JdevCompositeAccessor$ElementContainer.getInterfaceType must not return null");
            }
            return compositeServiceType;
        }

        private SCAInterface getInterface() {
            return this.service != null ? this.service.getInterface() : this.reference.getInterface();
        }
    }
}

