/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.i18n;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import oracle.bpel.activityguide.ui.beans.model.StateMapper;

public class I18NUtil {
    private static Locale gsLocale = null;
    private static ResourceBundle gsAGUIResourceBundle = null;
    private static ResourceBundle gsAGUIExceptionsList = null;
    public static final String I18N_AGUI_RESOURECE_BUNDLE = "oracle.bpel.activityguide.ui.i18n.AGUIResourceBundle";
    public static final String I18N_AGUI_EXCEPTION_LIST = "oracle.bpel.activityguide.ui.i18n.AGUIExceptionList";

    public static ResourceBundle getGsAGUIResourceBundle() {
        return gsAGUIResourceBundle;
    }

    public static ResourceBundle getGsAGUIExceptionsList() {
        return gsAGUIExceptionsList;
    }

    public static String getI18NiizedAGStatus(String s) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ExpressionFactory ef = fc.getApplication().getExpressionFactory();
        ELContext el = fc.getELContext();
        ValueExpression ve = ef.createValueExpression(el, "#{stateMapper}", StateMapper.class);
        StateMapper stateMapper = (StateMapper)ve.getValue(el);
        String key = stateMapper.getAg().get(s);
        if (gsAGUIResourceBundle != null) {
            return gsAGUIResourceBundle.getString(key);
        }
        return null;
    }

    public static void setGsLocale(Locale newLocale) {
        Locale oldLocale = I18NUtil.getGsLocale();
        if (!newLocale.equals(oldLocale)) {
            gsLocale = newLocale;
            gsAGUIResourceBundle = ResourceBundle.getBundle(I18N_AGUI_RESOURECE_BUNDLE, gsLocale);
            gsAGUIExceptionsList = ResourceBundle.getBundle(I18N_AGUI_EXCEPTION_LIST, gsLocale);
        }
    }

    public static Locale getGsLocale() {
        return gsLocale;
    }

    public static String getI18NiizedString(String s) {
        return gsAGUIResourceBundle.getString(s);
    }

    static {
        gsLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        gsAGUIResourceBundle = ResourceBundle.getBundle(I18N_AGUI_RESOURECE_BUNDLE, gsLocale);
        gsAGUIExceptionsList = ResourceBundle.getBundle(I18N_AGUI_EXCEPTION_LIST, gsLocale);
    }
}

