/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGException;
import oracle.bpel.activityguide.ui.beans.model.AGServiceInterfaceImpl;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.model.MilestoneInstance;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.worklist.api.util.WorklistUtil;

class TaskInstance {
    private static AGLog agLog = AGLogFactory.getLog(TaskInstance.class);
    private Task taskDetails = null;
    private Task task = null;
    private ResourceBundle bundle = null;
    private Object parent = null;
    private AGServiceInterfaceImpl impl = null;
    private TaskDisplayInfoType taskDisplayInfo = null;
    private String queryMode = null;
    private static List taskVerificationColumns = new ArrayList();

    TaskInstance(Task taskTypeInfo, Object parent, TaskDisplayInfoType taskDispInfo) {
        this.task = taskTypeInfo;
        this.parent = parent;
        this.taskDisplayInfo = taskDispInfo;
        this.impl = AGUtil.getAGServiceInterfaceImpl(parent);
    }

    Object getParent() {
        return this.parent;
    }

    String getTitle() {
        return this.task.getTitle();
    }

    String getTaskURL() {
        return this.getTaskDetailsURL();
    }

    Calendar getDueDate() {
        return this.task.getDueDate();
    }

    List getErrors() {
        return this.task.getTaskErrors();
    }

    String getTaskState() {
        return this.task.getSystemAttributes().getState();
    }

    String getTaskTextAttribute1() {
        return this.task.getSystemMessageAttributes().getTextAttribute1();
    }

    boolean isDisplayBlockedIcon() {
        if (this.taskDisplayInfo != null) {
            return this.taskDisplayInfo.isDisplayBlockedIcon();
        }
        return false;
    }

    String getBlockedExplanation() {
        if (this.taskDisplayInfo != null) {
            return this.taskDisplayInfo.getBlockedExplanation();
        }
        return null;
    }

    boolean isLastMilestoneTask() {
        if (this.taskDisplayInfo != null) {
            return this.taskDisplayInfo.isLastMilestoneTask();
        }
        return false;
    }

    boolean isTaskRequired() {
        if (this.isFutureTask()) {
            return false;
        }
        MilestoneInstance mInstance = (MilestoneInstance)this.parent;
        String queryMode = null;
        if (mInstance != null) {
            queryMode = mInstance.getProcessMode();
        }
        if (queryMode != null && queryMode.equalsIgnoreCase("AGBPM")) {
            return !this.taskDisplayInfo.isOptional();
        }
        return this.task.getSystemMessageAttributes().getTextAttribute1() != null && this.task.getSystemMessageAttributes().getTextAttribute1().equalsIgnoreCase("YES");
    }

    public String getQueryMode() {
        MilestoneInstance mInstance = (MilestoneInstance)this.parent;
        Object queryMode = null;
        if (mInstance != null) {
            return mInstance.getProcessMode();
        }
        return null;
    }

    public boolean isSwitchTask() {
        return this.task.getTitle().startsWith("switch");
    }

    public boolean isFutureTask() {
        return this.task.getSystemAttributes().getTaskId().startsWith("AGDM");
    }

    private IWorkflowServiceClient getWfSvcClient() throws Exception {
        return this.impl.getWfSvcClient();
    }

    private IWorkflowContext getWfContext() throws AGException {
        return this.impl.getWfCtx();
    }

    private String getWorklistURL() {
        return this.impl.getWorklistURL();
    }

    private String getTaskDetailsURL() {
        String detailsLink = null;
        if (this.isSwitchTask() || this.isFutureTask()) {
            return detailsLink;
        }
        try {
            Locale locale;
            String wlHttpURL = this.getWorklistURL();
            if (wlHttpURL == null) {
                throw new AGException(38016);
            }
            if (!wlHttpURL.contains("/faces")) {
                wlHttpURL = wlHttpURL + "/faces";
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("bpmWorklistTaskId", this.task.getSystemAttributes().getTaskId());
            parameters.put("bpmWorklistContext", this.getWfContext().getToken());
            parameters.put("bpmWorklistHttpURL", wlHttpURL);
            parameters.put("bpmBrowserWindowStatus", "keep");
            TimeZone timezone = this.getWfContext().getTimeZone();
            if (timezone != null) {
                parameters.put("tz", timezone.getID());
            }
            if ((locale = this.getWfContext().getLocale()) != null) {
                parameters.put("lg", locale.getLanguage());
                parameters.put("cy", locale.getCountry());
            }
            parameters.put("df", "medium");
            parameters.put("dt", "both");
            parameters.put("tf", "short");
            detailsLink = WorklistUtil.getTaskDisplayURL((IWorkflowServiceClient)this.getWfSvcClient(), (IWorkflowContext)this.getWfContext(), (Task)this.task, null, null, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detailsLink;
    }

    void release() {
    }

    private static void initTaskVerificationColumns() {
        taskVerificationColumns.add("ACQUIREDBY");
        taskVerificationColumns.add("ASSIGNEES");
        taskVerificationColumns.add("ASSIGNEEGROUPS");
        taskVerificationColumns.add("ASSIGNEEUSERS");
        taskVerificationColumns.add("REVIEWERS");
        taskVerificationColumns.add("OWNERUSER");
        taskVerificationColumns.add("OWNERGROUP");
        taskVerificationColumns.add("ORIGINALASSIGNEEUSER");
        taskVerificationColumns.add("PARTICIPANTNAME");
        taskVerificationColumns.add("APPROVERS");
        taskVerificationColumns.add("IDENTITYCONTEXT");
        taskVerificationColumns.add("TASKDEFINITIONNAME");
        taskVerificationColumns.add("COMPONENTNAME");
        taskVerificationColumns.add("CALLBACKID");
        taskVerificationColumns.add("STATE");
        taskVerificationColumns.add("SUBSTATE");
    }

    public TaskDisplayInfoType getTaskDisplayInfo() {
        return this.taskDisplayInfo;
    }
}

