/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;

public class StateMapper {
    AGLog agLog = AGLogFactory.getLog(StateMapper.class);
    protected HashMap<String, String> bpel = null;
    protected HashMap<String, String> ag = null;
    protected HashMap<String, String> milestone = null;
    protected HashMap<String, String> task = null;
    protected List<String> taskFilter = null;

    public StateMapper() {
        String method = "StateMapper";
        this.bpel = new HashMap();
        this.bpel.put("Running", "BPEL_STATE_RUNNING");
        this.bpel.put("Suspended", "BPEL_STATE_OPEN_SUSPENDED");
        this.bpel.put("Faulted", "BPEL_STATE_FAULTED");
        this.bpel.put("Completed Successfully", "BPEL_STATE_CLOSED_COMPLETED");
        this.bpel.put("Terminated By User", "BPEL_STATE_TERMINATED");
        this.bpel.put("Stale", "BPEL_STATE_CLOSED_STALE");
        if (this.agLog.isTrace()) {
            this.agLog.trace(AGUIInfoMsg.MSG_AG_STATE_MAPPER_AG.instance(method));
        }
        this.ag = new HashMap();
        this.ag.put("In Progress", "AG_STATE_INPROGRESS");
        this.ag.put("Completed", "AG_STATE_COMPLETED");
        this.ag.put("Completed With Warning", "AG_STATE_COMPLETED_WITH_WARNING");
        this.ag.put("Errored", "AG_STATE_ERRORED");
        this.ag.put("Terminated", "AG_STATE_TERMINATED");
        if (this.agLog.isTrace()) {
            this.agLog.trace(AGUIInfoMsg.MSG_AG_STATE_MAPPER_MILESTONE.instance(method));
        }
        this.milestone = new HashMap();
        this.milestone.put("Not Started", "AG_MILESTONE_STATE_NOTSTARTED");
        this.milestone.put("In Progress", "AG_MILESTONE_STATE_INPROGRESS");
        this.milestone.put("Completed", "AG_MILESTONE_STATE_COMPLETED");
        this.milestone.put("Errored", "AG_MILESTONE_STATE_ERRORED");
        this.milestone.put("Waiting", "AG_MILESTONE_STATE_WAITING");
        this.milestone.put("Expired", "AG_MILESTONE_STATE_EXPIRED");
        this.milestone.put("Completed With Warning", "AG_MILESTONE_STATE_COMPLETED_WITH_WARNING");
        this.milestone.put("Running With Warning", "AG_MILESTONE_STATE_RUNNING_WITH_WARNING");
        if (this.agLog.isTrace()) {
            this.agLog.trace(AGUIInfoMsg.MSG_AG_STATE_MAPPER_MILESTONE.instance(method));
        }
        this.task = new HashMap();
        this.task.put("ALERTED", "AG_TASK_STATE_ALERTED");
        this.task.put("ASSIGNED", "AG_TASK_STATE_ASSIGNED");
        this.task.put("COMPLETED", "AG_TASK_STATE_COMPLETED");
        this.task.put("DELETED", "AG_TASK_STATE_DELETED");
        this.task.put("ERRORED", "AG_TASK_STATE_ERRORED");
        this.task.put("EXPIRED", "AG_TASK_STATE_EXPIRED");
        this.task.put("INFO_REQUESTED", "AG_TASK_STATE_INFO_REQUESTED");
        this.task.put("OUTCOME_UPDATED", "AG_TASK_STATE_OUTCOME_UPDATED");
        this.task.put("STALE", "AG_TASK_STATE_STALE");
        this.task.put("SUSPENDED", "AG_TASK_STATE_SUSPENDED");
        this.task.put("WITHDRAWN", "AG_TASK_STATE_WITHDRAWN");
        this.taskFilter = new ArrayList<String>();
        this.taskFilter.add("AG_TASK_FILTER_ALL");
        this.taskFilter.add("AG_TASK_FILTER_REQUIRED");
        this.taskFilter.add("AG_TASK_FILTER_INPROGRESS");
        this.taskFilter.add("AG_TASK_FILTER_COMPLETED");
        this.taskFilter.add("AG_TASK_FILTER_OPTIONAL");
    }

    public HashMap<String, String> getBpel() {
        return this.bpel;
    }

    public HashMap<String, String> getAg() {
        return this.ag;
    }

    public HashMap<String, String> getMilestone() {
        return this.milestone;
    }

    public HashMap<String, String> getTask() {
        return this.task;
    }

    public List<String> getTaskFilter() {
        return this.taskFilter;
    }
}

