/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.faces.model.DataModel;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.SortCriterion;

public class RowKeyPropertyModel
extends CollectionModel {
    private final DataModel _model;
    private final String _rowKeyProperty;
    private SortCriterion _sortCriterion;
    private IntList _sortedIndicesList = null;
    private IntList _baseIndicesList = null;

    public RowKeyPropertyModel(Object instance, String rowKeyProperty) {
        this._model = ModelUtils.toDataModel((Object)instance);
        this._rowKeyProperty = rowKeyProperty;
    }

    public Object getRowKey() {
        if (this.isRowAvailable()) {
            Map data = (Map)this._model.getRowData();
            String rowKey = (String)data.get(this._rowKeyProperty);
            return rowKey;
        }
        return null;
    }

    public void setRowKey(Object key) {
        if (key == null) {
            this._model.setRowIndex(-1);
            return;
        }
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            this._model.setRowIndex(i);
            Map data = (Map)this._model.getRowData();
            if (!key.equals(data.get(this._rowKeyProperty))) continue;
            return;
        }
        this._model.setRowIndex(-1);
    }

    public Object getRowData() {
        return this._model.getRowData();
    }

    public Object getWrappedData() {
        return this._model.getWrappedData();
    }

    public boolean isRowAvailable() {
        return this._model.isRowAvailable();
    }

    public void setWrappedData(Object data) {
        this._model.setWrappedData(data);
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public void setRowIndex(int rowIndex) {
        int baseIndex = this._toBaseIndex(rowIndex);
        this._model.setRowIndex(baseIndex);
    }

    public int getRowIndex() {
        int baseIndex = this._model.getRowIndex();
        return this._toSortedIndex(baseIndex);
    }

    public boolean isSortable(String property) {
        if (this.getRowCount() > 0) {
            int rowIndex = this._model.getRowIndex();
            this._model.setRowIndex(0);
            Map data = (Map)this._model.getRowData();
            Object propertyValue = data.get(property);
            this._model.setRowIndex(rowIndex);
            return propertyValue instanceof Comparable;
        }
        return false;
    }

    public List getSortCriteria() {
        return this._sortCriterion == null ? Collections.EMPTY_LIST : Collections.singletonList(this._sortCriterion);
    }

    public void setSortCriteria(List criteria) {
        if (criteria == null || criteria.size() == 0) {
            return;
        }
        this._sortCriterion = (SortCriterion)criteria.get(0);
        this._sort(this._sortCriterion.getProperty(), this._sortCriterion.isAscending());
    }

    private void _sort(String property, boolean isAscending) {
        if (this._baseIndicesList == null) {
            this._baseIndicesList = new IntList(this.getRowCount());
        }
        int rowIndex = this._model.getRowIndex();
        this._model.setRowIndex(0);
        Comparator comp = new Comp(property);
        if (!isAscending) {
            comp = new Inverter(comp);
        }
        Collections.sort(this._baseIndicesList, comp);
        this._sortedIndicesList = null;
        this._model.setRowIndex(rowIndex);
    }

    private int _toBaseIndex(int sortedIndex) {
        return this._convertIndex(sortedIndex, this._baseIndicesList);
    }

    private int _toSortedIndex(int baseIndex) {
        if (this._sortedIndicesList == null && this._baseIndicesList != null) {
            this._sortedIndicesList = (IntList)this._baseIndicesList.clone();
            for (int i = 0; i < this._baseIndicesList.size(); ++i) {
                Integer base = (Integer)this._baseIndicesList.get(i);
                this._sortedIndicesList.set(base, new Integer(i));
            }
        }
        return this._convertIndex(baseIndex, this._sortedIndicesList);
    }

    private int _convertIndex(int index, List indices) {
        if (index < 0) {
            return index;
        }
        if (indices != null && indices.size() > index) {
            index = (Integer)indices.get(index);
        }
        return index;
    }

    private static final class IntList
    extends ArrayList
    implements Cloneable {
        public IntList(int size) {
            super(size);
            this._expandToSize(size);
        }

        private void _expandToSize(int desiredSize) {
            for (int i = 0; i < desiredSize; ++i) {
                this.add(new Integer(i));
            }
        }
    }

    private static final class Inverter
    implements Comparator {
        private final Comparator _comp;

        public Inverter(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object o1, Object o2) {
            return this._comp.compare(o2, o1);
        }
    }

    private final class Comp
    implements Comparator {
        private final String _property;

        public Comp(String property) {
            this._property = property;
        }

        public int compare(Object o1, Object o2) {
            int index1 = (Integer)o1;
            int index2 = (Integer)o2;
            RowKeyPropertyModel.this._model.setRowIndex(index1);
            Map data1 = (Map)RowKeyPropertyModel.this._model.getRowData();
            Object isDir1 = data1.get("isDirectory");
            RowKeyPropertyModel.this._model.setRowIndex(index2);
            Map data2 = (Map)RowKeyPropertyModel.this._model.getRowData();
            Object isDir2 = data2.get("isDirectory");
            if (Boolean.TRUE.equals(isDir1) && !Boolean.TRUE.equals(isDir2)) {
                return -1;
            }
            if (Boolean.TRUE.equals(isDir2) && !Boolean.TRUE.equals(isDir1)) {
                return 1;
            }
            Comparable comp1 = (Comparable)data1.get(this._property);
            Comparable comp2 = (Comparable)data2.get(this._property);
            return comp1.compareTo(comp2);
        }
    }
}

